/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.moshi.adapters;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonDataException;
import com.squareup.moshi.JsonReader;
import com.squareup.moshi.JsonWriter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.Types;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;

public final class PolymorphicJsonAdapterFactory<T>
implements JsonAdapter.Factory {
    final Class<T> baseType;
    final String labelKey;
    final List<String> labels;
    final List<Type> subtypes;
    @Nullable
    final JsonAdapter<Object> fallbackJsonAdapter;

    PolymorphicJsonAdapterFactory(Class<T> baseType, String labelKey, List<String> labels, List<Type> subtypes, @Nullable JsonAdapter<Object> fallbackJsonAdapter) {
        this.baseType = baseType;
        this.labelKey = labelKey;
        this.labels = labels;
        this.subtypes = subtypes;
        this.fallbackJsonAdapter = fallbackJsonAdapter;
    }

    @CheckReturnValue
    public static <T> PolymorphicJsonAdapterFactory<T> of(Class<T> baseType, String labelKey) {
        if (baseType == null) {
            throw new NullPointerException("baseType == null");
        }
        if (labelKey == null) {
            throw new NullPointerException("labelKey == null");
        }
        return new PolymorphicJsonAdapterFactory<T>(baseType, labelKey, Collections.emptyList(), Collections.emptyList(), null);
    }

    public PolymorphicJsonAdapterFactory<T> withSubtype(Class<? extends T> subtype, String label) {
        if (subtype == null) {
            throw new NullPointerException("subtype == null");
        }
        if (label == null) {
            throw new NullPointerException("label == null");
        }
        if (this.labels.contains(label)) {
            throw new IllegalArgumentException("Labels must be unique.");
        }
        ArrayList<String> newLabels = new ArrayList<String>(this.labels);
        newLabels.add(label);
        ArrayList<Type> newSubtypes = new ArrayList<Type>(this.subtypes);
        newSubtypes.add(subtype);
        return new PolymorphicJsonAdapterFactory<T>(this.baseType, this.labelKey, newLabels, newSubtypes, this.fallbackJsonAdapter);
    }

    public PolymorphicJsonAdapterFactory<T> withFallbackJsonAdapter(@Nullable JsonAdapter<Object> fallbackJsonAdapter) {
        return new PolymorphicJsonAdapterFactory<T>(this.baseType, this.labelKey, this.labels, this.subtypes, fallbackJsonAdapter);
    }

    public PolymorphicJsonAdapterFactory<T> withDefaultValue(@Nullable T defaultValue) {
        return this.withFallbackJsonAdapter(this.buildFallbackJsonAdapter(defaultValue));
    }

    private JsonAdapter<Object> buildFallbackJsonAdapter(final T defaultValue) {
        return new JsonAdapter<Object>(){

            @Nullable
            public Object fromJson(JsonReader reader) throws IOException {
                reader.skipValue();
                return defaultValue;
            }

            public void toJson(JsonWriter writer, Object value) throws IOException {
                throw new IllegalArgumentException("Expected one of " + PolymorphicJsonAdapterFactory.this.subtypes + " but found " + value + ", a " + value.getClass() + ". Register this subtype.");
            }
        };
    }

    public JsonAdapter<?> create(Type type, Set<? extends Annotation> annotations, Moshi moshi) {
        if (Types.getRawType((Type)type) != this.baseType || !annotations.isEmpty()) {
            return null;
        }
        ArrayList<JsonAdapter<Object>> jsonAdapters = new ArrayList<JsonAdapter<Object>>(this.subtypes.size());
        int size = this.subtypes.size();
        for (int i = 0; i < size; ++i) {
            jsonAdapters.add(moshi.adapter(this.subtypes.get(i)));
        }
        return new PolymorphicJsonAdapter(this.labelKey, this.labels, this.subtypes, jsonAdapters, this.fallbackJsonAdapter).nullSafe();
    }

    static final class PolymorphicJsonAdapter
    extends JsonAdapter<Object> {
        final String labelKey;
        final List<String> labels;
        final List<Type> subtypes;
        final List<JsonAdapter<Object>> jsonAdapters;
        @Nullable
        final JsonAdapter<Object> fallbackJsonAdapter;
        final JsonReader.Options labelKeyOptions;
        final JsonReader.Options labelOptions;

        PolymorphicJsonAdapter(String labelKey, List<String> labels, List<Type> subtypes, List<JsonAdapter<Object>> jsonAdapters, @Nullable JsonAdapter<Object> fallbackJsonAdapter) {
            this.labelKey = labelKey;
            this.labels = labels;
            this.subtypes = subtypes;
            this.jsonAdapters = jsonAdapters;
            this.fallbackJsonAdapter = fallbackJsonAdapter;
            this.labelKeyOptions = JsonReader.Options.of((String[])new String[]{labelKey});
            this.labelOptions = JsonReader.Options.of((String[])labels.toArray(new String[0]));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object fromJson(JsonReader reader) throws IOException {
            int labelIndex;
            peeked.setFailOnUnknown(false);
            try (JsonReader peeked = reader.peekJson();){
                labelIndex = this.labelIndex(peeked);
            }
            if (labelIndex == -1) {
                return this.fallbackJsonAdapter.fromJson(reader);
            }
            return this.jsonAdapters.get(labelIndex).fromJson(reader);
        }

        private int labelIndex(JsonReader reader) throws IOException {
            reader.beginObject();
            while (reader.hasNext()) {
                if (reader.selectName(this.labelKeyOptions) == -1) {
                    reader.skipName();
                    reader.skipValue();
                    continue;
                }
                int labelIndex = reader.selectString(this.labelOptions);
                if (labelIndex == -1 && this.fallbackJsonAdapter == null) {
                    throw new JsonDataException("Expected one of " + this.labels + " for key '" + this.labelKey + "' but found '" + reader.nextString() + "'. Register a subtype for this label.");
                }
                return labelIndex;
            }
            throw new JsonDataException("Missing label for " + this.labelKey);
        }

        public void toJson(JsonWriter writer, Object value) throws IOException {
            JsonAdapter<Object> adapter;
            Class<?> type = value.getClass();
            int labelIndex = this.subtypes.indexOf(type);
            if (labelIndex == -1) {
                if (this.fallbackJsonAdapter == null) {
                    throw new IllegalArgumentException("Expected one of " + this.subtypes + " but found " + value + ", a " + value.getClass() + ". Register this subtype.");
                }
                adapter = this.fallbackJsonAdapter;
            } else {
                adapter = this.jsonAdapters.get(labelIndex);
            }
            writer.beginObject();
            if (adapter != this.fallbackJsonAdapter) {
                writer.name(this.labelKey).value(this.labels.get(labelIndex));
            }
            int flattenToken = writer.beginFlatten();
            adapter.toJson(writer, value);
            writer.endFlatten(flattenToken);
            writer.endObject();
        }

        public String toString() {
            return "PolymorphicJsonAdapter(" + this.labelKey + ")";
        }
    }
}

