/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.runtime.impl;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class ArrayRangeIterator
implements Iterator {
    public static final ArrayRangeIterator EMPTY_ITERATOR = new ArrayRangeIterator(null, 0, 0);
    protected Object[] m_array;
    protected int m_offset;
    protected int m_limit;

    private ArrayRangeIterator(Object[] array, int start, int limit) {
        this.m_array = array;
        this.m_offset = start;
        this.m_limit = limit;
    }

    @Override
    public boolean hasNext() {
        return this.m_offset < this.m_limit;
    }

    public Object next() {
        if (this.m_offset < this.m_limit) {
            return this.m_array[this.m_offset++];
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public static Iterator buildIterator(Object[] array, int start, int limit) {
        if (array == null || start >= limit) {
            return EMPTY_ITERATOR;
        }
        return new ArrayRangeIterator(array, start, limit);
    }
}

