/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.deployment;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.AddressingHelper;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.DeploymentClassLoader;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.DescriptionBuilder;
import org.apache.axis2.deployment.util.PhasesInfo;
import org.apache.axis2.deployment.util.Utils;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisOperationFactory;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.InOutAxisOperation;
import org.apache.axis2.description.ModuleConfiguration;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.ParameterInclude;
import org.apache.axis2.description.java2wsdl.TypeTable;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.engine.ObjectSupplier;
import org.apache.axis2.engine.ServiceLifeCycle;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.util.JavaUtils;
import org.apache.axis2.util.Loader;
import org.apache.axis2.util.PolicyUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.Constants;

public class ServiceBuilder
extends DescriptionBuilder {
    private static final Log log = LogFactory.getLog(ServiceBuilder.class);
    private AxisService service;
    private Map<String, AxisService> wsdlServiceMap = new HashMap<String, AxisService>();

    public ServiceBuilder(ConfigurationContext configCtx, AxisService service) {
        this.service = service;
        this.configCtx = configCtx;
        this.axisConfig = this.configCtx.getAxisConfiguration();
    }

    public ServiceBuilder(InputStream serviceInputStream, ConfigurationContext configCtx, AxisService service) {
        super(serviceInputStream, configCtx);
        this.service = service;
    }

    public AxisService populateService(OMElement service_element) throws DeploymentException {
        try {
            OMElement mappingElement;
            String sessionScope;
            Iterator<OMElement> policyRefElements;
            OMElement messageReceiver;
            OMElement schemaElement;
            OMAttribute targetNameSpace;
            OMAttribute addressingRequiredatt;
            OMElement descriptionElement;
            ClassLoader cl;
            OMAttribute serviceNameatt;
            String serviceActivate = service_element.getAttributeValue(new QName("activate"));
            if (serviceActivate != null) {
                if ("true".equals(serviceActivate)) {
                    this.service.setActive(true);
                } else if ("false".equals(serviceActivate)) {
                    this.service.setActive(false);
                }
            }
            if ((serviceNameatt = service_element.getAttribute(new QName("name"))) != null && !"".equals(serviceNameatt.getAttributeValue().trim())) {
                AxisService wsdlService = this.wsdlServiceMap.get(serviceNameatt.getAttributeValue());
                if (wsdlService != null) {
                    wsdlService.setClassLoader(this.service.getClassLoader());
                    wsdlService.setParent(this.service.getAxisServiceGroup());
                    this.service = wsdlService;
                    this.service.setWsdlFound(true);
                    this.service.setCustomWsdl(true);
                }
                this.service.setName(serviceNameatt.getAttributeValue());
                if (this.service.getDocumentation() == null) {
                    this.service.setDocumentation(serviceNameatt.getAttributeValue());
                }
            }
            Iterator itr = service_element.getChildrenWithName(new QName("parameter"));
            this.processParameters(itr, this.service, this.service.getParent());
            Parameter childFirstClassLoading = this.service.getParameter("EnableChildFirstClassLoading");
            if (childFirstClassLoading != null && (cl = this.service.getClassLoader()) instanceof DeploymentClassLoader) {
                DeploymentClassLoader deploymentClassLoader = (DeploymentClassLoader)cl;
                if (JavaUtils.isTrueExplicitly(childFirstClassLoading.getValue())) {
                    deploymentClassLoader.setChildFirstClassLoading(true);
                } else if (JavaUtils.isFalseExplicitly(childFirstClassLoading.getValue())) {
                    deploymentClassLoader.setChildFirstClassLoading(false);
                }
            }
            if ((descriptionElement = service_element.getFirstChildWithName(new QName("description"))) == null) {
                descriptionElement = service_element.getFirstChildWithName(new QName("Description"));
            }
            if (descriptionElement != null) {
                OMElement descriptionValue = descriptionElement.getFirstElement();
                if (descriptionValue != null) {
                    this.service.setDocumentation((OMNode)descriptionValue);
                } else {
                    this.service.setDocumentation(descriptionElement.getText());
                }
            } else {
                serviceNameatt = service_element.getAttribute(new QName("name"));
                if (serviceNameatt != null && !"".equals(serviceNameatt.getAttributeValue().trim()) && this.service.getDocumentation() == null) {
                    this.service.setDocumentation(serviceNameatt.getAttributeValue());
                }
            }
            if (this.service.getParameter("ServiceClass") == null) {
                log.debug((Object)("The Service " + this.service.getName() + " does not specify a Service Class"));
            }
            if ((addressingRequiredatt = service_element.getAttribute(new QName("wsaddressing"))) != null) {
                String addressingRequiredString = addressingRequiredatt.getAttributeValue();
                AddressingHelper.setAddressingRequirementParemeterValue(this.service, addressingRequiredString);
            }
            if ((targetNameSpace = service_element.getAttribute(new QName("targetNamespace"))) != null) {
                String nameSpeceVale = targetNameSpace.getAttributeValue();
                if (nameSpeceVale != null && !"".equals(nameSpeceVale)) {
                    this.service.setTargetNamespace(nameSpeceVale);
                }
            } else if (this.service.getTargetNamespace() == null || "".equals(this.service.getTargetNamespace())) {
                this.service.setTargetNamespace("http://ws.apache.org/axis2");
            }
            OMAttribute serviceLifeCycleClass = service_element.getAttribute(new QName("class"));
            if (serviceLifeCycleClass != null) {
                String className = serviceLifeCycleClass.getAttributeValue();
                this.loadServiceLifeCycleClass(className);
            }
            if ((schemaElement = service_element.getFirstChildWithName(new QName("schema"))) != null) {
                Iterator mappingIterator;
                OMAttribute elementFormDefault;
                String nameSpeceVale;
                OMAttribute schemaNameSpace = schemaElement.getAttribute(new QName("schemaNamespace"));
                if (schemaNameSpace != null && (nameSpeceVale = schemaNameSpace.getAttributeValue()) != null && !"".equals(nameSpeceVale)) {
                    this.service.setSchemaTargetNamespace(nameSpeceVale);
                }
                if ((elementFormDefault = schemaElement.getAttribute(new QName("elementFormDefaultQualified"))) != null) {
                    String value = elementFormDefault.getAttributeValue();
                    if ("true".equals(value)) {
                        this.service.setElementFormDefault(true);
                    } else if ("false".equals(value)) {
                        this.service.setElementFormDefault(false);
                    }
                }
                if ((mappingIterator = schemaElement.getChildrenWithName(new QName("mapping"))) != null) {
                    Hashtable<String, String> hashtable = new Hashtable<String, String>();
                    while (mappingIterator.hasNext()) {
                        OMElement mappingElement2 = (OMElement)mappingIterator.next();
                        OMAttribute namespaceAttribute = mappingElement2.getAttribute(new QName("namespace"));
                        OMAttribute packageAttribute = mappingElement2.getAttribute(new QName("package"));
                        if (namespaceAttribute != null && packageAttribute != null) {
                            String namespaceAttributeValue = namespaceAttribute.getAttributeValue();
                            String packageAttributeValue = packageAttribute.getAttributeValue();
                            if (namespaceAttributeValue != null && packageAttributeValue != null) {
                                hashtable.put(packageAttributeValue.trim(), namespaceAttributeValue.trim());
                                continue;
                            }
                            log.warn((Object)"Either value of @namespce or @packagename not available. Thus, generated will be selected.");
                            continue;
                        }
                        log.warn((Object)"Either @namespce or @packagename not available. Thus, generated will be selected.");
                    }
                    this.service.setP2nMap(hashtable);
                }
            }
            if ((messageReceiver = service_element.getFirstChildWithName(new QName("messageReceivers"))) != null) {
                HashMap<String, MessageReceiver> mrs = this.processMessageReceivers(this.service.getClassLoader(), messageReceiver);
                for (Map.Entry entry : mrs.entrySet()) {
                    this.service.addMessageReceiver((String)entry.getKey(), (MessageReceiver)entry.getValue());
                }
            }
            OMElement excludeOperations = service_element.getFirstChildWithName(new QName("excludeOperations"));
            ArrayList<String> excludeops = null;
            if (excludeOperations != null) {
                excludeops = this.processExcludeOperations(excludeOperations);
            }
            if (excludeops == null) {
                excludeops = new ArrayList();
            }
            Utils.addExcludeMethods(excludeops);
            Iterator<OMElement> iterator = PolicyUtil.getPolicyChildren(service_element);
            if (iterator != null && iterator.hasNext()) {
                this.processPolicyElements(iterator, this.service.getPolicySubject());
            }
            if ((policyRefElements = PolicyUtil.getPolicyRefChildren(service_element)) != null && policyRefElements.hasNext()) {
                this.processPolicyRefElements(policyRefElements, this.service.getPolicySubject());
            }
            if ((sessionScope = service_element.getAttributeValue(new QName("scope"))) != null) {
                this.service.setScope(sessionScope);
            }
            Iterator moduleRefs = service_element.getChildrenWithName(new QName("module"));
            this.processModuleRefs(moduleRefs);
            OMElement transports = service_element.getFirstChildWithName(new QName("transports"));
            if (transports != null) {
                Iterator transport_itr = transports.getChildrenWithName(new QName("transport"));
                ArrayList<String> trs = new ArrayList<String>();
                while (transport_itr.hasNext()) {
                    OMElement trsEle = (OMElement)transport_itr.next();
                    String transportName = trsEle.getText().trim();
                    if (this.axisConfig.getTransportIn(transportName) == null) {
                        log.warn((Object)("Service [ " + this.service.getName() + "] is trying to expose in a transport : " + transportName + " and which is not available in Axis2"));
                        continue;
                    }
                    trs.add(transportName);
                }
                if (trs.isEmpty()) {
                    throw new AxisFault("Service [" + this.service.getName() + "] is trying expose in tranpsorts: " + transports + " and which is/are not available in Axis2");
                }
                this.service.setExposedTransports(trs);
            }
            Iterator operationsIterator = service_element.getChildrenWithName(new QName("operation"));
            ArrayList<AxisOperation> ops = this.processOperations(operationsIterator);
            for (int i = 0; i < ops.size(); ++i) {
                AxisOperation operationDesc = ops.get(i);
                ArrayList<String> wsamappings = operationDesc.getWSAMappingList();
                if (wsamappings == null) continue;
                if (this.service.getOperation(operationDesc.getName()) == null) {
                    this.service.addOperation(operationDesc);
                }
                for (int j = 0; j < wsamappings.size(); ++j) {
                    String mapping = wsamappings.get(j);
                    if (mapping.length() <= 0) continue;
                    this.service.mapActionToOperation(mapping, operationDesc);
                }
            }
            String objectSupplierValue = (String)this.service.getParameterValue("ObjectSupplier");
            if (objectSupplierValue != null) {
                this.loadObjectSupplierClass(objectSupplierValue);
            }
            this.setDefaultMessageReceivers();
            Utils.processBeanPropertyExclude(this.service);
            if (!this.service.isUseUserWSDL() && !this.service.isWsdlFound()) {
                try {
                    if (this.generateWsdl(this.service)) {
                        Utils.fillAxisService(this.service, this.axisConfig, excludeops, null);
                    } else {
                        ArrayList<String> nonRpcOperations = this.getNonRPCMethods(this.service);
                        Utils.fillAxisService(this.service, this.axisConfig, excludeops, nonRpcOperations);
                    }
                }
                catch (Exception e) {
                    throw new DeploymentException(Messages.getMessage("errorinschemagen", e.getMessage()), e);
                }
            }
            if (this.service.isCustomWsdl() && (mappingElement = service_element.getFirstChildWithName(new QName("packageMapping"))) != null) {
                this.processTypeMappings(mappingElement);
            }
            for (String opName : excludeops) {
                this.service.removeOperation(new QName(opName));
                this.service.addExcludeOperationName(opName);
            }
            this.setDefaultMessageReceivers();
            Iterator moduleConfigs = service_element.getChildrenWithName(new QName("moduleConfig"));
            this.processServiceModuleConfig(moduleConfigs, this.service, this.service);
            OMElement dataLocatorElement = service_element.getFirstChildWithName(new QName("dataLocator"));
            if (dataLocatorElement != null) {
                this.processDataLocatorConfig(dataLocatorElement, this.service);
            }
            this.processEndpoints(this.service);
            this.processPolicyAttachments(service_element, this.service);
        }
        catch (AxisFault axisFault) {
            throw new DeploymentException(axisFault);
        }
        this.startupServiceLifecycle();
        return this.service;
    }

    private void setDefaultMessageReceivers() {
        for (AxisOperation operation : this.service.getPublishedOperations()) {
            if (operation.getMessageReceiver() != null) continue;
            MessageReceiver messageReceiver = this.loadDefaultMessageReceiver(operation.getMessageExchangePattern(), this.service);
            if (messageReceiver == null && "http://www.w3.org/ns/wsdl/robust-in-only".equals(operation.getMessageExchangePattern())) {
                messageReceiver = this.loadDefaultMessageReceiver("http://www.w3.org/ns/wsdl/in-out", this.service);
            }
            operation.setMessageReceiver(messageReceiver);
        }
    }

    private void loadObjectSupplierClass(String objectSupplierValue) throws AxisFault {
        try {
            ClassLoader loader = this.service.getClassLoader();
            Class objectSupplierImpl = Loader.loadClass(loader, objectSupplierValue.trim());
            ObjectSupplier objectSupplier = (ObjectSupplier)objectSupplierImpl.newInstance();
            this.service.setObjectSupplier(objectSupplier);
        }
        catch (Exception e) {
            throw AxisFault.makeFault(e);
        }
    }

    private void processTypeMappings(OMElement packageMappingElement) {
        Iterator elementItr = packageMappingElement.getChildrenWithName(new QName("mapping"));
        TypeTable typeTable = this.service.getTypeTable();
        if (typeTable == null) {
            typeTable = new TypeTable();
        }
        while (elementItr.hasNext()) {
            OMElement mappingElement = (OMElement)elementItr.next();
            String packageName = mappingElement.getAttributeValue(new QName("packageName"));
            String qName = mappingElement.getAttributeValue(new QName("qName"));
            if (packageName == null || qName == null) continue;
            for (String key : this.service.getNamespaceMap().keySet()) {
                if (!qName.equals(this.service.getNamespaceMap().get(key))) continue;
                typeTable.addComplexSchema(packageName, new QName(qName, packageName, key));
            }
        }
        this.service.setTypeTable(typeTable);
    }

    private void loadServiceLifeCycleClass(String className) throws DeploymentException {
        if (className != null) {
            try {
                ClassLoader loader = this.service.getClassLoader();
                Class serviceLifeCycleClassImpl = Loader.loadClass(loader, className);
                ServiceLifeCycle serviceLifeCycle = (ServiceLifeCycle)serviceLifeCycleClassImpl.newInstance();
                this.service.setServiceLifeCycle(serviceLifeCycle);
            }
            catch (Exception e) {
                throw new DeploymentException(e.getMessage(), e);
            }
        }
    }

    private boolean generateWsdl(AxisService axisService) {
        Iterator<AxisOperation> operatins = axisService.getOperations();
        if (operatins.hasNext()) {
            while (operatins.hasNext()) {
                String messageReceiverClass;
                AxisOperation axisOperation = operatins.next();
                if (axisOperation.isControlOperation() || axisOperation.getMessageReceiver() == null || "org.apache.axis2.rpc.receivers.RPCMessageReceiver".equals(messageReceiverClass = axisOperation.getMessageReceiver().getClass().getName()) || "org.apache.axis2.rpc.receivers.RPCInOnlyMessageReceiver".equals(messageReceiverClass) || "org.apache.axis2.rpc.receivers.RPCInOutAsyncMessageReceiver".equals(messageReceiverClass) || "org.apache.axis2.jaxws.server.JAXWSMessageReceiver".equals(messageReceiverClass)) continue;
                return false;
            }
        }
        return true;
    }

    private ArrayList<String> getNonRPCMethods(AxisService axisService) {
        ArrayList<String> excludeOperations = new ArrayList<String>();
        Iterator<AxisOperation> operatins = axisService.getOperations();
        if (operatins.hasNext()) {
            while (operatins.hasNext()) {
                String messageReceiverClass;
                AxisOperation axisOperation = operatins.next();
                if (axisOperation.getMessageReceiver() == null || "org.apache.axis2.rpc.receivers.RPCMessageReceiver".equals(messageReceiverClass = axisOperation.getMessageReceiver().getClass().getName()) || "org.apache.axis2.rpc.receivers.RPCInOnlyMessageReceiver".equals(messageReceiverClass) || "org.apache.axis2.rpc.receivers.RPCInOutAsyncMessageReceiver".equals(messageReceiverClass) || "org.apache.axis2.jaxws.server.JAXWSMessageReceiver".equals(messageReceiverClass)) continue;
                excludeOperations.add(axisOperation.getName().getLocalPart());
            }
        }
        return excludeOperations;
    }

    private ArrayList<String> processExcludeOperations(OMElement excludeOperations) {
        ArrayList<String> exOps = new ArrayList<String>();
        Iterator excludeOp_itr = excludeOperations.getChildrenWithName(new QName("operation"));
        while (excludeOp_itr.hasNext()) {
            OMElement opName = (OMElement)excludeOp_itr.next();
            exOps.add(opName.getText().trim());
        }
        return exOps;
    }

    private void processMessages(Iterator messages, AxisOperation operation) throws DeploymentException {
        while (messages.hasNext()) {
            Iterator<OMElement> policyRefElements;
            OMElement messageElement = (OMElement)messages.next();
            OMAttribute label = messageElement.getAttribute(new QName("label"));
            if (label == null) {
                throw new DeploymentException(Messages.getMessage("messagelabelcannotfound"));
            }
            AxisMessage message = operation.getMessage(label.getAttributeValue());
            Iterator parameters = messageElement.getChildrenWithName(new QName("parameter"));
            Iterator<OMElement> policyElements = PolicyUtil.getPolicyChildren(messageElement);
            if (policyElements != null) {
                this.processPolicyElements(policyElements, message.getPolicySubject());
            }
            if ((policyRefElements = PolicyUtil.getPolicyRefChildren(messageElement)) != null) {
                this.processPolicyRefElements(policyRefElements, message.getPolicySubject());
            }
            this.processParameters(parameters, message, operation);
        }
    }

    protected void processModuleRefs(Iterator moduleRefs) throws DeploymentException {
        while (moduleRefs.hasNext()) {
            OMElement moduleref = (OMElement)moduleRefs.next();
            OMAttribute moduleRefAttribute = moduleref.getAttribute(new QName("ref"));
            if (moduleRefAttribute == null) continue;
            String refName = moduleRefAttribute.getAttributeValue();
            this.service.addModuleref(refName);
        }
    }

    protected void processOperationModuleConfig(Iterator moduleConfigs, ParameterInclude parent, AxisOperation operation) throws DeploymentException {
        while (moduleConfigs.hasNext()) {
            OMElement moduleConfig = (OMElement)moduleConfigs.next();
            OMAttribute moduleName_att = moduleConfig.getAttribute(new QName("name"));
            if (moduleName_att == null) {
                throw new DeploymentException(Messages.getMessage("invalidmoduleconfig"));
            }
            String module = moduleName_att.getAttributeValue();
            ModuleConfiguration moduleConfiguration = new ModuleConfiguration(module, parent);
            Iterator parameters = moduleConfig.getChildrenWithName(new QName("parameter"));
            this.processParameters(parameters, moduleConfiguration, parent);
            operation.addModuleConfig(moduleConfiguration);
        }
    }

    private ArrayList<AxisOperation> processOperations(Iterator operationsIterator) throws AxisFault {
        ArrayList<AxisOperation> operations = new ArrayList<AxisOperation>();
        while (operationsIterator.hasNext()) {
            Iterator<OMElement> policyRefElements;
            Iterator<OMElement> policyElements;
            OMElement operation = (OMElement)operationsIterator.next();
            OMAttribute op_name_att = operation.getAttribute(new QName("name"));
            if (op_name_att == null) {
                throw new DeploymentException(Messages.getMessage(Messages.getMessage("invalid_op", "operation name missing")));
            }
            OMAttribute op_mep_att = operation.getAttribute(new QName("mep"));
            String mepurl = null;
            if (op_mep_att != null) {
                mepurl = op_mep_att.getAttributeValue();
            }
            String opname = op_name_att.getAttributeValue();
            AxisOperation op_descrip = null;
            OMAttribute operationNamespace = operation.getAttribute(new QName("namespace"));
            if (operationNamespace != null) {
                String namespace = operationNamespace.getAttributeValue();
                op_descrip = this.service.getOperation(new QName(namespace, opname));
            }
            if (op_descrip == null) {
                op_descrip = this.service.getOperation(new QName(opname));
            }
            if (op_descrip == null) {
                op_descrip = this.service.getOperation(new QName(this.service.getTargetNamespace(), opname));
            }
            if (op_descrip == null) {
                AxisMessage outAxisMessage;
                AxisMessage inaxisMessage;
                if (mepurl == null) {
                    op_descrip = new InOutAxisOperation();
                    op_descrip.setParent(this.service);
                } else {
                    op_descrip = AxisOperationFactory.getOperationDescription(mepurl);
                }
                op_descrip.setName(new QName(opname));
                String MEP = op_descrip.getMessageExchangePattern();
                if (("http://www.w3.org/ns/wsdl/in-only".equals(MEP) || "http://www.w3.org/ns/wsdl/in-opt-out".equals(MEP) || "http://www.w3.org/ns/wsdl/out-opt-in".equals(MEP) || "http://www.w3.org/ns/wsdl/robust-out-only".equals(MEP) || "http://www.w3.org/ns/wsdl/robust-in-only".equals(MEP) || "http://www.w3.org/ns/wsdl/in-out".equals(MEP)) && (inaxisMessage = op_descrip.getMessage("In")) != null) {
                    inaxisMessage.setName(opname + "Request");
                }
                if (("http://www.w3.org/ns/wsdl/out-only".equals(MEP) || "http://www.w3.org/ns/wsdl/out-opt-in".equals(MEP) || "http://www.w3.org/ns/wsdl/in-opt-out".equals(MEP) || "http://www.w3.org/ns/wsdl/robust-out-only".equals(MEP) || "http://www.w3.org/ns/wsdl/in-out".equals(MEP)) && (outAxisMessage = op_descrip.getMessage("Out")) != null) {
                    outAxisMessage.setName(opname + "Response");
                }
            }
            if ((policyElements = PolicyUtil.getPolicyChildren(operation)) != null && policyElements.hasNext()) {
                this.processPolicyElements(policyElements, op_descrip.getPolicySubject());
            }
            if ((policyRefElements = PolicyUtil.getPolicyRefChildren(operation)) != null && policyRefElements.hasNext()) {
                this.processPolicyRefElements(policyRefElements, op_descrip.getPolicySubject());
            }
            Iterator parameters = operation.getChildrenWithName(new QName("parameter"));
            this.processParameters(parameters, op_descrip, this.service);
            this.processActionMappings(operation, op_descrip);
            OMElement receiverElement = operation.getFirstChildWithName(new QName("messageReceiver"));
            if (receiverElement != null) {
                MessageReceiver messageReceiver = this.loadMessageReceiver(this.service.getClassLoader(), receiverElement);
                op_descrip.setMessageReceiver(messageReceiver);
            } else {
                MessageReceiver msgReceiver = this.loadDefaultMessageReceiver(op_descrip.getMessageExchangePattern(), this.service);
                op_descrip.setMessageReceiver(msgReceiver);
            }
            Iterator modules = operation.getChildrenWithName(new QName("module"));
            this.processOperationModuleRefs(modules, op_descrip);
            Iterator messages = operation.getChildrenWithName(new QName("message"));
            this.processMessages(messages, op_descrip);
            if (this.axisConfig != null) {
                PhasesInfo info = this.axisConfig.getPhasesInfo();
                info.setOperationPhases(op_descrip);
            }
            Iterator moduleConfigs = operation.getChildrenWithName(new QName("moduleConfig"));
            this.processOperationModuleConfig(moduleConfigs, op_descrip, op_descrip);
            operations.add(op_descrip);
        }
        return operations;
    }

    protected void processServiceModuleConfig(Iterator moduleConfigs, ParameterInclude parent, AxisService service) throws DeploymentException {
        while (moduleConfigs.hasNext()) {
            OMElement moduleConfig = (OMElement)moduleConfigs.next();
            OMAttribute moduleName_att = moduleConfig.getAttribute(new QName("name"));
            if (moduleName_att == null) {
                throw new DeploymentException(Messages.getMessage("invalidmoduleconfig"));
            }
            String module = moduleName_att.getAttributeValue();
            ModuleConfiguration moduleConfiguration = new ModuleConfiguration(module, parent);
            Iterator parameters = moduleConfig.getChildrenWithName(new QName("parameter"));
            this.processParameters(parameters, moduleConfiguration, parent);
            service.addModuleConfig(moduleConfiguration);
        }
    }

    private void processDataLocatorConfig(OMElement dataLocatorElement, AxisService service) {
        OMAttribute serviceOverallDataLocatorclass = dataLocatorElement.getAttribute(new QName("class"));
        if (serviceOverallDataLocatorclass != null) {
            String className = serviceOverallDataLocatorclass.getAttributeValue();
            service.addDataLocatorClassNames("ServiceLevel", className);
        }
        Iterator iterator = dataLocatorElement.getChildrenWithName(new QName("dialectLocator"));
        while (iterator.hasNext()) {
            OMElement locatorElement = (OMElement)iterator.next();
            OMAttribute dialect = locatorElement.getAttribute(new QName("dialect"));
            OMAttribute dialectclass = locatorElement.getAttribute(new QName("class"));
            service.addDataLocatorClassNames(dialect.getAttributeValue(), dialectclass.getAttributeValue());
        }
    }

    public void setWsdlServiceMap(Map<String, AxisService> wsdlServiceMap) {
        this.wsdlServiceMap = wsdlServiceMap;
    }

    private void processEndpoints(AxisService axisService) throws AxisFault {
        String endpointName = axisService.getEndpointName();
        if (endpointName == null || endpointName.length() == 0) {
            Utils.addEndpointsToService(axisService, this.service.getAxisConfiguration());
        }
    }

    private void processPolicyAttachments(OMElement serviceElement, AxisService service) throws DeploymentException {
        ArrayList<OMElement> attachmentElements = new ArrayList<OMElement>();
        Iterator it = serviceElement.getChildElements();
        while (it.hasNext()) {
            OMElement elem = (OMElement)it.next();
            if (!Constants.isPolicyNS((String)elem.getNamespaceURI()) || !elem.getLocalName().equals("PolicyAttachment")) continue;
            attachmentElements.add(elem);
        }
        try {
            Utils.processPolicyAttachments(attachmentElements.iterator(), service);
        }
        catch (Exception e) {
            throw new DeploymentException(e);
        }
    }

    private void startupServiceLifecycle() {
        if (this.service.getServiceLifeCycle() != null) {
            this.service.getServiceLifeCycle().startUp(this.configCtx, this.service);
        }
    }
}

