// Licensed to the Apache Software Foundation (ASF) under one or more
// contributor license agreements.  See the NOTICE file distributed with
// this work for additional information regarding copyright ownership.
// The ASF licenses this file to You under the Apache License, Version 2.0
// (the "License"); you may not use this file except in compliance with
// the License.  You may obtain a copy of the License at
//
//	http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
package translation

import (
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestValidateRemoteAddrs(t *testing.T) {
	addrs := []string{
		"192.168.3.4",
		"192.168.3.3/16",
		"123",
	}
	err := ValidateRemoteAddrs(addrs)
	assert.Equal(t, _errInvalidAddress, err)

	addrs = []string{
		"192.168.3.4",
		"192.168.3.3/16",
		"2001:db8::68",
		"2001:db8:a0b:12f0::1/32",
	}
	assert.Nil(t, ValidateRemoteAddrs(addrs))
}
