<p>Packages:</p>
<ul>
<li>
<a href="#apisix.apache.org%2fv2">apisix.apache.org/v2</a>
</li>
</ul>
<h2 id="apisix.apache.org/v2">apisix.apache.org/v2</h2>
<div>
</div>
Resource Types:
<ul><li>
<a href="#apisix.apache.org/v2.ApisixGlobalRule">ApisixGlobalRule</a>
</li><li>
<a href="#apisix.apache.org/v2.ApisixPluginConfig">ApisixPluginConfig</a>
</li></ul>
<h3 id="apisix.apache.org/v2.ApisixGlobalRule">ApisixGlobalRule
</h3>
<div>
<p>ApisixGlobalRule is the Schema for the ApisixGlobalRule resource.
An ApisixGlobalRule is used to support a group of plugin configs</p>
</div>
<table>
<thead>
<tr>
<th>Field</th>
<th>Description</th>
</tr>
</thead>
<tbody>
<tr>
<td>
<code>apiVersion</code><br/>
string</td>
<td>
<code>
apisix.apache.org/v2
</code>
</td>
</tr>
<tr>
<td>
<code>kind</code><br/>
string
</td>
<td><code>ApisixGlobalRule</code></td>
</tr>
<tr>
<td>
<code>metadata</code><br/>
<em>
<a href="https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#objectmeta-v1-meta">
Kubernetes meta/v1.ObjectMeta
</a>
</em>
</td>
<td>
Refer to the Kubernetes API documentation for the fields of the
<code>metadata</code> field.
</td>
</tr>
<tr>
<td>
<code>spec</code><br/>
<em>
<a href="#apisix.apache.org/v2.ApisixGlobalRuleSpec">
ApisixGlobalRuleSpec
</a>
</em>
</td>
<td>
<p>Spec defines the desired state of ApisixGlobalRuleSpec.</p>
<br/>
<br/>
<table>
<tr>
<td>
<code>plugins</code><br/>
<em>
<a href="#apisix.apache.org/v2.ApisixRoutePlugin">
[]ApisixRoutePlugin
</a>
</em>
</td>
<td>
<p>Plugins contains a list of ApisixRoutePlugin</p>
</td>
</tr>
</table>
</td>
</tr>
<tr>
<td>
<code>status</code><br/>
<em>
<a href="#apisix.apache.org/v2.ApisixStatus">
ApisixStatus
</a>
</em>
</td>
<td>
</td>
</tr>
</tbody>
</table>
<h3 id="apisix.apache.org/v2.ApisixPluginConfig">ApisixPluginConfig
</h3>
<div>
<p>ApisixPluginConfig is the Schema for the ApisixPluginConfig resource.
An ApisixPluginConfig is used to support a group of plugin configs</p>
</div>
<table>
<thead>
<tr>
<th>Field</th>
<th>Description</th>
</tr>
</thead>
<tbody>
<tr>
<td>
<code>apiVersion</code><br/>
string</td>
<td>
<code>
apisix.apache.org/v2
</code>
</td>
</tr>
<tr>
<td>
<code>kind</code><br/>
string
</td>
<td><code>ApisixPluginConfig</code></td>
</tr>
<tr>
<td>
<code>metadata</code><br/>
<em>
<a href="https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#objectmeta-v1-meta">
Kubernetes meta/v1.ObjectMeta
</a>
</em>
</td>
<td>
Refer to the Kubernetes API documentation for the fields of the
<code>metadata</code> field.
</td>
</tr>
<tr>
<td>
<code>spec</code><br/>
<em>
<a href="#apisix.apache.org/v2.ApisixPluginConfigSpec">
ApisixPluginConfigSpec
</a>
</em>
</td>
<td>
<p>Spec defines the desired state of ApisixPluginConfigSpec.</p>
<br/>
<br/>
<table>
<tr>
<td>
<code>plugins</code><br/>
<em>
<a href="#apisix.apache.org/v2.ApisixRoutePlugin">
[]ApisixRoutePlugin
</a>
</em>
</td>
<td>
<p>Plugins contains a list of ApisixRoutePlugin</p>
</td>
</tr>
</table>
</td>
</tr>
<tr>
<td>
<code>status</code><br/>
<em>
<a href="#apisix.apache.org/v2.ApisixStatus">
ApisixStatus
</a>
</em>
</td>
<td>
</td>
</tr>
</tbody>
</table>
<h3 id="apisix.apache.org/v2.ActiveHealthCheck">ActiveHealthCheck
</h3>
<p>
(<em>Appears on:</em><a href="#apisix.apache.org/v2.HealthCheck">HealthCheck</a>)
</p>
<div>
<p>ActiveHealthCheck defines the active kind of upstream health check.</p>
</div>
<table>
<thead>
<tr>
<th>Field</th>
<th>Description</th>
</tr>
</thead>
<tbody>
<tr>
<td>
<code>type</code><br/>
<em>
string
</em>
</td>
<td>
</td>
</tr>
<tr>
<td>
<code>timeout</code><br/>
<em>
time.Duration
</em>
</td>
<td>
</td>
</tr>
<tr>
<td>
<code>concurrency</code><br/>
<em>
int
</em>
</td>
<td>
</td>
</tr>
<tr>
<td>
<code>host</code><br/>
<em>
string
</em>
</td>
<td>
</td>
</tr>
<tr>
<td>
<code>port</code><br/>
<em>
int32
</em>
</td>
<td>
</td>
</tr>
<tr>
<td>
<code>httpPath</code><br/>
<em>
string
</em>
</td>
<td>
</td>
</tr>
<tr>
<td>
<code>strictTLS</code><br/>
<em>
bool
</em>
</td>
<td>
</td>
</tr>
<tr>
<td>
<code>requestHeaders</code><br/>
<em>
[]string
</em>
</td>
<td>
</td>
</tr>
<tr>
<td>
<code>healthy</code><br/>
<em>
<a href="#apisix.apache.org/v2.ActiveHealthCheckHealthy">
ActiveHealthCheckHealthy
</a>
</em>
</td>
<td>
</td>
</tr>
<tr>
<td>
<code>unhealthy</code><br/>
<em>
<a href="#apisix.apache.org/v2.ActiveHealthCheckUnhealthy">
ActiveHealthCheckUnhealthy
</a>
</em>
</td>
<td>
</td>
</tr>
</tbody>
</table>
<h3 id="apisix.apache.org/v2.ActiveHealthCheckHealthy">ActiveHealthCheckHealthy
</h3>
<p>
(<em>Appears on:</em><a href="#apisix.apache.org/v2.ActiveHealthCheck">ActiveHealthCheck</a>)
</p>
<div>
<p>ActiveHealthCheckHealthy defines the conditions to judge whether
an upstream node is healthy with the active manner.</p>
</div>
<table>
<thead>
<tr>
<th>Field</th>
<th>Description</th>
</tr>
</thead>
<tbody>
<tr>
<td>
<code>PassiveHealthCheckHealthy</code><br/>
<em>
<a href="#apisix.apache.org/v2.PassiveHealthCheckHealthy">
PassiveHealthCheckHealthy
</a>
</em>
</td>
<td>
<p>
(Members of <code>PassiveHealthCheckHealthy</code> are embedded into this type.)
</p>
</td>
</tr>
<tr>
<td>
<code>interval</code><br/>
<em>
<a href="https://godoc.org/k8s.io/apimachinery/pkg/apis/meta/v1#Duration">
Kubernetes meta/v1.Duration
</a>
</em>
</td>
<td>
</td>
</tr>
</tbody>
</table>
<h3 id="apisix.apache.org/v2.ActiveHealthCheckUnhealthy">ActiveHealthCheckUnhealthy
</h3>
<p>
(<em>Appears on:</em><a href="#apisix.apache.org/v2.ActiveHealthCheck">ActiveHealthCheck</a>)
</p>
<div>
<p>ActiveHealthCheckUnhealthy defines the conditions to judge whether
an upstream node is unhealthy with the active manager.</p>
</div>
<table>
<thead>
<tr>
<th>Field</th>
<th>Description</th>
</tr>
</thead>
<tbody>
<tr>
<td>
<code>PassiveHealthCheckUnhealthy</code><br/>
<em>
<a href="#apisix.apache.org/v2.PassiveHealthCheckUnhealthy">
PassiveHealthCheckUnhealthy
</a>
</em>
</td>
<td>
<p>
(Members of <code>PassiveHealthCheckUnhealthy</code> are embedded into this type.)
</p>
</td>
</tr>
<tr>
<td>
<code>interval</code><br/>
<em>
<a href="https://godoc.org/k8s.io/apimachinery/pkg/apis/meta/v1#Duration">
Kubernetes meta/v1.Duration
</a>
</em>
</td>
<td>
</td>
</tr>
</tbody>
</table>
<h3 id="apisix.apache.org/v2.ApisixClusterAdminConfig">ApisixClusterAdminConfig
</h3>
<p>
(<em>Appears on:</em><a href="#apisix.apache.org/v2.ApisixClusterConfigSpec">ApisixClusterConfigSpec</a>)
</p>
<div>
<p>ApisixClusterAdminConfig is the admin config for the corresponding APISIX Cluster.</p>
</div>
<table>
<thead>
<tr>
<th>Field</th>
<th>Description</th>
</tr>
</thead>
<tbody>
<tr>
<td>
<code>baseURL</code><br/>
<em>
string
</em>
</td>
<td>
<p>BaseURL is the base URL for the APISIX Admin API.
It looks like &ldquo;<a href="http://apisix-admin.default.svc.cluster.local:9080/apisix/admin&quot;">http://apisix-admin.default.svc.cluster.local:9080/apisix/admin&rdquo;</a></p>
</td>
</tr>
<tr>
<td>
<code>adminKey</code><br/>
<em>
string
</em>
</td>
<td>
<p>AdminKey is used to verify the admin API user.</p>
</td>
</tr>
<tr>
<td>
<code>clientTimeout</code><br/>
<em>
github.com/apache/apisix-ingress-controller/pkg/types.TimeDuration
</em>
</td>
<td>
<p>ClientTimeout is request timeout for the APISIX Admin API client</p>
</td>
</tr>
</tbody>
</table>
<h3 id="apisix.apache.org/v2.ApisixClusterConfig">ApisixClusterConfig
</h3>
<div>
<p>ApisixClusterConfig is the Schema for the ApisixClusterConfig resource.
An ApisixClusterConfig is used to identify an APISIX cluster, it&rsquo;s a
ClusterScoped resource so the name is unique.
It also contains some cluster-level configurations like monitoring.</p>
</div>
<table>
<thead>
<tr>
<th>Field</th>
<th>Description</th>
</tr>
</thead>
<tbody>
<tr>
<td>
<code>metadata</code><br/>
<em>
<a href="https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#objectmeta-v1-meta">
Kubernetes meta/v1.ObjectMeta
</a>
</em>
</td>
<td>
Refer to the Kubernetes API documentation for the fields of the
<code>metadata</code> field.
</td>
</tr>
<tr>
<td>
<code>spec</code><br/>
<em>
<a href="#apisix.apache.org/v2.ApisixClusterConfigSpec">
ApisixClusterConfigSpec
</a>
</em>
</td>
<td>
<p>Spec defines the desired state of ApisixClusterConfigSpec.</p>
<br/>
<br/>
<table>
<tr>
<td>
<code>monitoring</code><br/>
<em>
<a href="#apisix.apache.org/v2.ApisixClusterMonitoringConfig">
ApisixClusterMonitoringConfig
</a>
</em>
</td>
<td>
<em>(Optional)</em>
<p>Monitoring categories all monitoring related features.</p>
</td>
</tr>
<tr>
<td>
<code>admin</code><br/>
<em>
<a href="#apisix.apache.org/v2.ApisixClusterAdminConfig">
ApisixClusterAdminConfig
</a>
</em>
</td>
<td>
<em>(Optional)</em>
<p>Admin contains the Admin API information about APISIX cluster.</p>
</td>
</tr>
</table>
</td>
</tr>
<tr>
<td>
<code>status</code><br/>
<em>
<a href="#apisix.apache.org/v2.ApisixStatus">
ApisixStatus
</a>
</em>
</td>
<td>
</td>
</tr>
</tbody>
</table>
<h3 id="apisix.apache.org/v2.ApisixClusterConfigSpec">ApisixClusterConfigSpec
</h3>
<p>
(<em>Appears on:</em><a href="#apisix.apache.org/v2.ApisixClusterConfig">ApisixClusterConfig</a>)
</p>
<div>
<p>ApisixClusterConfigSpec defines the desired state of ApisixClusterConfigSpec.</p>
</div>
<table>
<thead>
<tr>
<th>Field</th>
<th>Description</th>
</tr>
</thead>
<tbody>
<tr>
<td>
<code>monitoring</code><br/>
<em>
<a href="#apisix.apache.org/v2.ApisixClusterMonitoringConfig">
ApisixClusterMonitoringConfig
</a>
</em>
</td>
<td>
<em>(Optional)</em>
<p>Monitoring categories all monitoring related features.</p>
</td>
</tr>
<tr>
<td>
<code>admin</code><br/>
<em>
<a href="#apisix.apache.org/v2.ApisixClusterAdminConfig">
ApisixClusterAdminConfig
</a>
</em>
</td>
<td>
<em>(Optional)</em>
<p>Admin contains the Admin API information about APISIX cluster.</p>
</td>
</tr>
</tbody>
</table>
<h3 id="apisix.apache.org/v2.ApisixClusterMonitoringConfig">ApisixClusterMonitoringConfig
</h3>
<p>
(<em>Appears on:</em><a href="#apisix.apache.org/v2.ApisixClusterConfigSpec">ApisixClusterConfigSpec</a>)
</p>
<div>
<p>ApisixClusterMonitoringConfig categories all monitoring related features.</p>
</div>
<table>
<thead>
<tr>
<th>Field</th>
<th>Description</th>
</tr>
</thead>
<tbody>
<tr>
<td>
<code>prometheus</code><br/>
<em>
<a href="#apisix.apache.org/v2.ApisixClusterPrometheusConfig">
ApisixClusterPrometheusConfig
</a>
</em>
</td>
<td>
<em>(Optional)</em>
<p>Prometheus is the config for using Prometheus in APISIX Cluster.</p>
</td>
</tr>
<tr>
<td>
<code>skywalking</code><br/>
<em>
<a href="#apisix.apache.org/v2.ApisixClusterSkywalkingConfig">
ApisixClusterSkywalkingConfig
</a>
</em>
</td>
<td>
<em>(Optional)</em>
<p>Skywalking is the config for using Skywalking in APISIX Cluster.</p>
</td>
</tr>
</tbody>
</table>
<h3 id="apisix.apache.org/v2.ApisixClusterPrometheusConfig">ApisixClusterPrometheusConfig
</h3>
<p>
(<em>Appears on:</em><a href="#apisix.apache.org/v2.ApisixClusterMonitoringConfig">ApisixClusterMonitoringConfig</a>)
</p>
<div>
<p>ApisixClusterPrometheusConfig is the config for using Prometheus in APISIX Cluster.</p>
</div>
<table>
<thead>
<tr>
<th>Field</th>
<th>Description</th>
</tr>
</thead>
<tbody>
<tr>
<td>
<code>enable</code><br/>
<em>
bool
</em>
</td>
<td>
<p>Enable means whether enable Prometheus or not.</p>
</td>
</tr>
</tbody>
</table>
<h3 id="apisix.apache.org/v2.ApisixClusterSkywalkingConfig">ApisixClusterSkywalkingConfig
</h3>
<p>
(<em>Appears on:</em><a href="#apisix.apache.org/v2.ApisixClusterMonitoringConfig">ApisixClusterMonitoringConfig</a>)
</p>
<div>
<p>ApisixClusterSkywalkingConfig is the config for using Skywalking in APISIX Cluster.</p>
</div>
<table>
<thead>
<tr>
<th>Field</th>
<th>Description</th>
</tr>
</thead>
<tbody>
<tr>
<td>
<code>enable</code><br/>
<em>
bool
</em>
</td>
<td>
<p>Enable means whether enable Skywalking or not.</p>
</td>
</tr>
<tr>
<td>
<code>sampleRatio</code><br/>
<em>
float64
</em>
</td>
<td>
<p>SampleRatio means the ratio to collect</p>
</td>
</tr>
</tbody>
</table>
<h3 id="apisix.apache.org/v2.ApisixConsumer">ApisixConsumer
</h3>
<div>
<p>ApisixConsumer is the Schema for the ApisixConsumer resource.
An ApisixConsumer is used to identify a consumer.</p>
</div>
<table>
<thead>
<tr>
<th>Field</th>
<th>Description</th>
</tr>
</thead>
<tbody>
<tr>
<td>
<code>metadata</code><br/>
<em>
<a href="https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#objectmeta-v1-meta">
Kubernetes meta/v1.ObjectMeta
</a>
</em>
</td>
<td>
Refer to the Kubernetes API documentation for the fields of the
<code>metadata</code> field.
</td>
</tr>
<tr>
<td>
<code>spec</code><br/>
<em>
<a href="#apisix.apache.org/v2.ApisixConsumerSpec">
ApisixConsumerSpec
</a>
</em>
</td>
<td>
<br/>
<br/>
<table>
<tr>
<td>
<code>authParameter</code><br/>
<em>
<a href="#apisix.apache.org/v2.ApisixConsumerAuthParameter">
ApisixConsumerAuthParameter
</a>
</em>
</td>
<td>
</td>
</tr>
</table>
</td>
</tr>
<tr>
<td>
<code>status</code><br/>
<em>
<a href="#apisix.apache.org/v2.ApisixStatus">
ApisixStatus
</a>
</em>
</td>
<td>
</td>
</tr>
</tbody>
</table>
<h3 id="apisix.apache.org/v2.ApisixConsumerAuthParameter">ApisixConsumerAuthParameter
</h3>
<p>
(<em>Appears on:</em><a href="#apisix.apache.org/v2.ApisixConsumerSpec">ApisixConsumerSpec</a>)
</p>
<div>
</div>
<table>
<thead>
<tr>
<th>Field</th>
<th>Description</th>
</tr>
</thead>
<tbody>
<tr>
<td>
<code>basicAuth</code><br/>
<em>
<a href="#apisix.apache.org/v2.ApisixConsumerBasicAuth">
ApisixConsumerBasicAuth
</a>
</em>
</td>
<td>
</td>
</tr>
<tr>
<td>
<code>keyAuth</code><br/>
<em>
<a href="#apisix.apache.org/v2.ApisixConsumerKeyAuth">
ApisixConsumerKeyAuth
</a>
</em>
</td>
<td>
</td>
</tr>
<tr>
<td>
<code>wolfRBAC</code><br/>
<em>
<a href="#apisix.apache.org/v2.ApisixConsumerWolfRBAC">
ApisixConsumerWolfRBAC
</a>
</em>
</td>
<td>
</td>
</tr>
<tr>
<td>
<code>jwtAuth</code><br/>
<em>
<a href="#apisix.apache.org/v2.ApisixConsumerJwtAuth">
ApisixConsumerJwtAuth
</a>
</em>
</td>
<td>
</td>
</tr>
<tr>
<td>
<code>hmacAuth</code><br/>
<em>
<a href="#apisix.apache.org/v2.ApisixConsumerHMACAuth">
ApisixConsumerHMACAuth
</a>
</em>
</td>
<td>
</td>
</tr>
</tbody>
</table>
<h3 id="apisix.apache.org/v2.ApisixConsumerBasicAuth">ApisixConsumerBasicAuth
</h3>
<p>
(<em>Appears on:</em><a href="#apisix.apache.org/v2.ApisixConsumerAuthParameter">ApisixConsumerAuthParameter</a>)
</p>
<div>
<p>ApisixConsumerBasicAuth defines the configuration for basic auth.</p>
</div>
<table>
<thead>
<tr>
<th>Field</th>
<th>Description</th>
</tr>
</thead>
<tbody>
<tr>
<td>
<code>secretRef</code><br/>
<em>
<a href="https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#localobjectreference-v1-core">
Kubernetes core/v1.LocalObjectReference
</a>
</em>
</td>
<td>
</td>
</tr>
<tr>
<td>
<code>value</code><br/>
<em>
<a href="#apisix.apache.org/v2.ApisixConsumerBasicAuthValue">
ApisixConsumerBasicAuthValue
</a>
</em>
</td>
<td>
</td>
</tr>
</tbody>
</table>
<h3 id="apisix.apache.org/v2.ApisixConsumerBasicAuthValue">ApisixConsumerBasicAuthValue
</h3>
<p>
(<em>Appears on:</em><a href="#apisix.apache.org/v2.ApisixConsumerBasicAuth">ApisixConsumerBasicAuth</a>)
</p>
<div>
<p>ApisixConsumerBasicAuthValue defines the in-place username and password configuration for basic auth.</p>
</div>
<table>
<thead>
<tr>
<th>Field</th>
<th>Description</th>
</tr>
</thead>
<tbody>
<tr>
<td>
<code>username</code><br/>
<em>
string
</em>
</td>
<td>
</td>
</tr>
<tr>
<td>
<code>password</code><br/>
<em>
string
</em>
</td>
<td>
</td>
</tr>
</tbody>
</table>
<h3 id="apisix.apache.org/v2.ApisixConsumerHMACAuth">ApisixConsumerHMACAuth
</h3>
<p>
(<em>Appears on:</em><a href="#apisix.apache.org/v2.ApisixConsumerAuthParameter">ApisixConsumerAuthParameter</a>)
</p>
<div>
<p>ApisixConsumerHMACAuth defines the configuration for the hmac auth.</p>
</div>
<table>
<thead>
<tr>
<th>Field</th>
<th>Description</th>
</tr>
</thead>
<tbody>
<tr>
<td>
<code>secretRef</code><br/>
<em>
<a href="https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#localobjectreference-v1-core">
Kubernetes core/v1.LocalObjectReference
</a>
</em>
</td>
<td>
</td>
</tr>
<tr>
<td>
<code>value</code><br/>
<em>
<a href="#apisix.apache.org/v2.ApisixConsumerHMACAuthValue">
ApisixConsumerHMACAuthValue
</a>
</em>
</td>
<td>
</td>
</tr>
</tbody>
</table>
<h3 id="apisix.apache.org/v2.ApisixConsumerHMACAuthValue">ApisixConsumerHMACAuthValue
</h3>
<p>
(<em>Appears on:</em><a href="#apisix.apache.org/v2.ApisixConsumerHMACAuth">ApisixConsumerHMACAuth</a>)
</p>
<div>
<p>ApisixConsumerHMACAuthValue defines the in-place configuration for hmac auth.</p>
</div>
<table>
<thead>
<tr>
<th>Field</th>
<th>Description</th>
</tr>
</thead>
<tbody>
<tr>
<td>
<code>access_key</code><br/>
<em>
string
</em>
</td>
<td>
</td>
</tr>
<tr>
<td>
<code>secret_key</code><br/>
<em>
string
</em>
</td>
<td>
</td>
</tr>
<tr>
<td>
<code>algorithm</code><br/>
<em>
string
</em>
</td>
<td>
</td>
</tr>
<tr>
<td>
<code>clock_skew</code><br/>
<em>
int64
</em>
</td>
<td>
</td>
</tr>
<tr>
<td>
<code>signed_headers</code><br/>
<em>
[]string
</em>
</td>
<td>
</td>
</tr>
<tr>
<td>
<code>keep_headers</code><br/>
<em>
bool
</em>
</td>
<td>
</td>
</tr>
<tr>
<td>
<code>encode_uri_params</code><br/>
<em>
bool
</em>
</td>
<td>
</td>
</tr>
<tr>
<td>
<code>validate_request_body</code><br/>
<em>
bool
</em>
</td>
<td>
</td>
</tr>
<tr>
<td>
<code>max_req_body</code><br/>
<em>
int64
</em>
</td>
<td>
</td>
</tr>
</tbody>
</table>
<h3 id="apisix.apache.org/v2.ApisixConsumerJwtAuth">ApisixConsumerJwtAuth
</h3>
<p>
(<em>Appears on:</em><a href="#apisix.apache.org/v2.ApisixConsumerAuthParameter">ApisixConsumerAuthParameter</a>)
</p>
<div>
<p>ApisixConsumerJwtAuth defines the configuration for the jwt auth.</p>
</div>
<table>
<thead>
<tr>
<th>Field</th>
<th>Description</th>
</tr>
</thead>
<tbody>
<tr>
<td>
<code>secretRef</code><br/>
<em>
<a href="https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#localobjectreference-v1-core">
Kubernetes core/v1.LocalObjectReference
</a>
</em>
</td>
<td>
</td>
</tr>
<tr>
<td>
<code>value</code><br/>
<em>
<a href="#apisix.apache.org/v2.ApisixConsumerJwtAuthValue">
ApisixConsumerJwtAuthValue
</a>
</em>
</td>
<td>
</td>
</tr>
</tbody>
</table>
<h3 id="apisix.apache.org/v2.ApisixConsumerJwtAuthValue">ApisixConsumerJwtAuthValue
</h3>
<p>
(<em>Appears on:</em><a href="#apisix.apache.org/v2.ApisixConsumerJwtAuth">ApisixConsumerJwtAuth</a>)
</p>
<div>
<p>ApisixConsumerJwtAuthValue defines the in-place configuration for jwt auth.</p>
</div>
<table>
<thead>
<tr>
<th>Field</th>
<th>Description</th>
</tr>
</thead>
<tbody>
<tr>
<td>
<code>key</code><br/>
<em>
string
</em>
</td>
<td>
</td>
</tr>
<tr>
<td>
<code>secret</code><br/>
<em>
string
</em>
</td>
<td>
</td>
</tr>
<tr>
<td>
<code>public_key</code><br/>
<em>
string
</em>
</td>
<td>
</td>
</tr>
<tr>
<td>
<code>private_key</code><br/>
<em>
string
</em>
</td>
<td>
</td>
</tr>
<tr>
<td>
<code>algorithm</code><br/>
<em>
string
</em>
</td>
<td>
</td>
</tr>
<tr>
<td>
<code>exp</code><br/>
<em>
int64
</em>
</td>
<td>
</td>
</tr>
<tr>
<td>
<code>base64_secret</code><br/>
<em>
bool
</em>
</td>
<td>
</td>
</tr>
</tbody>
</table>
<h3 id="apisix.apache.org/v2.ApisixConsumerKeyAuth">ApisixConsumerKeyAuth
</h3>
<p>
(<em>Appears on:</em><a href="#apisix.apache.org/v2.ApisixConsumerAuthParameter">ApisixConsumerAuthParameter</a>)
</p>
<div>
<p>ApisixConsumerKeyAuth defines the configuration for the key auth.</p>
</div>
<table>
<thead>
<tr>
<th>Field</th>
<th>Description</th>
</tr>
</thead>
<tbody>
<tr>
<td>
<code>secretRef</code><br/>
<em>
<a href="https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#localobjectreference-v1-core">
Kubernetes core/v1.LocalObjectReference
</a>
</em>
</td>
<td>
</td>
</tr>
<tr>
<td>
<code>value</code><br/>
<em>
<a href="#apisix.apache.org/v2.ApisixConsumerKeyAuthValue">
ApisixConsumerKeyAuthValue
</a>
</em>
</td>
<td>
</td>
</tr>
</tbody>
</table>
<h3 id="apisix.apache.org/v2.ApisixConsumerKeyAuthValue">ApisixConsumerKeyAuthValue
</h3>
<p>
(<em>Appears on:</em><a href="#apisix.apache.org/v2.ApisixConsumerKeyAuth">ApisixConsumerKeyAuth</a>)
</p>
<div>
<p>ApisixConsumerKeyAuthValue defines the in-place configuration for basic auth.</p>
</div>
<table>
<thead>
<tr>
<th>Field</th>
<th>Description</th>
</tr>
</thead>
<tbody>
<tr>
<td>
<code>key</code><br/>
<em>
string
</em>
</td>
<td>
</td>
</tr>
</tbody>
</table>
<h3 id="apisix.apache.org/v2.ApisixConsumerSpec">ApisixConsumerSpec
</h3>
<p>
(<em>Appears on:</em><a href="#apisix.apache.org/v2.ApisixConsumer">ApisixConsumer</a>)
</p>
<div>
<p>ApisixConsumerSpec defines the desired state of ApisixConsumer.</p>
</div>
<table>
<thead>
<tr>
<th>Field</th>
<th>Description</th>
</tr>
</thead>
<tbody>
<tr>
<td>
<code>authParameter</code><br/>
<em>
<a href="#apisix.apache.org/v2.ApisixConsumerAuthParameter">
ApisixConsumerAuthParameter
</a>
</em>
</td>
<td>
</td>
</tr>
</tbody>
</table>
<h3 id="apisix.apache.org/v2.ApisixConsumerWolfRBAC">ApisixConsumerWolfRBAC
</h3>
<p>
(<em>Appears on:</em><a href="#apisix.apache.org/v2.ApisixConsumerAuthParameter">ApisixConsumerAuthParameter</a>)
</p>
<div>
<p>ApisixConsumerWolfRBAC defines the configuration for the wolf-rbac auth.</p>
</div>
<table>
<thead>
<tr>
<th>Field</th>
<th>Description</th>
</tr>
</thead>
<tbody>
<tr>
<td>
<code>secretRef</code><br/>
<em>
<a href="https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#localobjectreference-v1-core">
Kubernetes core/v1.LocalObjectReference
</a>
</em>
</td>
<td>
</td>
</tr>
<tr>
<td>
<code>value</code><br/>
<em>
<a href="#apisix.apache.org/v2.ApisixConsumerWolfRBACValue">
ApisixConsumerWolfRBACValue
</a>
</em>
</td>
<td>
</td>
</tr>
</tbody>
</table>
<h3 id="apisix.apache.org/v2.ApisixConsumerWolfRBACValue">ApisixConsumerWolfRBACValue
</h3>
<p>
(<em>Appears on:</em><a href="#apisix.apache.org/v2.ApisixConsumerWolfRBAC">ApisixConsumerWolfRBAC</a>)
</p>
<div>
<p>ApisixConsumerWolfRBAC defines the in-place server and appid and header_prefix configuration for wolf-rbac auth.</p>
</div>
<table>
<thead>
<tr>
<th>Field</th>
<th>Description</th>
</tr>
</thead>
<tbody>
<tr>
<td>
<code>server</code><br/>
<em>
string
</em>
</td>
<td>
</td>
</tr>
<tr>
<td>
<code>appid</code><br/>
<em>
string
</em>
</td>
<td>
</td>
</tr>
<tr>
<td>
<code>header_prefix</code><br/>
<em>
string
</em>
</td>
<td>
</td>
</tr>
</tbody>
</table>
<h3 id="apisix.apache.org/v2.ApisixGlobalRuleSpec">ApisixGlobalRuleSpec
</h3>
<p>
(<em>Appears on:</em><a href="#apisix.apache.org/v2.ApisixGlobalRule">ApisixGlobalRule</a>)
</p>
<div>
<p>ApisixGlobalRuleSpec defines the desired state of ApisixGlobalRuleSpec.</p>
</div>
<table>
<thead>
<tr>
<th>Field</th>
<th>Description</th>
</tr>
</thead>
<tbody>
<tr>
<td>
<code>plugins</code><br/>
<em>
<a href="#apisix.apache.org/v2.ApisixRoutePlugin">
[]ApisixRoutePlugin
</a>
</em>
</td>
<td>
<p>Plugins contains a list of ApisixRoutePlugin</p>
</td>
</tr>
</tbody>
</table>
<h3 id="apisix.apache.org/v2.ApisixMutualTlsClientConfig">ApisixMutualTlsClientConfig
</h3>
<p>
(<em>Appears on:</em><a href="#apisix.apache.org/v2.ApisixTlsSpec">ApisixTlsSpec</a>)
</p>
<div>
<p>ApisixMutualTlsClientConfig describes the mutual TLS CA and verify depth</p>
</div>
<table>
<thead>
<tr>
<th>Field</th>
<th>Description</th>
</tr>
</thead>
<tbody>
<tr>
<td>
<code>caSecret</code><br/>
<em>
<a href="#apisix.apache.org/v2.ApisixSecret">
ApisixSecret
</a>
</em>
</td>
<td>
</td>
</tr>
<tr>
<td>
<code>depth</code><br/>
<em>
int
</em>
</td>
<td>
</td>
</tr>
</tbody>
</table>
<h3 id="apisix.apache.org/v2.ApisixPluginConfigSpec">ApisixPluginConfigSpec
</h3>
<p>
(<em>Appears on:</em><a href="#apisix.apache.org/v2.ApisixPluginConfig">ApisixPluginConfig</a>)
</p>
<div>
<p>ApisixPluginConfigSpec defines the desired state of ApisixPluginConfigSpec.</p>
</div>
<table>
<thead>
<tr>
<th>Field</th>
<th>Description</th>
</tr>
</thead>
<tbody>
<tr>
<td>
<code>plugins</code><br/>
<em>
<a href="#apisix.apache.org/v2.ApisixRoutePlugin">
[]ApisixRoutePlugin
</a>
</em>
</td>
<td>
<p>Plugins contains a list of ApisixRoutePlugin</p>
</td>
</tr>
</tbody>
</table>
<h3 id="apisix.apache.org/v2.ApisixRoute">ApisixRoute
</h3>
<div>
<p>ApisixRoute is used to define the route rules and upstreams for Apache APISIX.</p>
</div>
<table>
<thead>
<tr>
<th>Field</th>
<th>Description</th>
</tr>
</thead>
<tbody>
<tr>
<td>
<code>metadata</code><br/>
<em>
<a href="https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#objectmeta-v1-meta">
Kubernetes meta/v1.ObjectMeta
</a>
</em>
</td>
<td>
Refer to the Kubernetes API documentation for the fields of the
<code>metadata</code> field.
</td>
</tr>
<tr>
<td>
<code>spec</code><br/>
<em>
<a href="#apisix.apache.org/v2.ApisixRouteSpec">
ApisixRouteSpec
</a>
</em>
</td>
<td>
<br/>
<br/>
<table>
<tr>
<td>
<code>http</code><br/>
<em>
<a href="#apisix.apache.org/v2.ApisixRouteHTTP">
[]ApisixRouteHTTP
</a>
</em>
</td>
<td>
</td>
</tr>
<tr>
<td>
<code>stream</code><br/>
<em>
<a href="#apisix.apache.org/v2.ApisixRouteStream">
[]ApisixRouteStream
</a>
</em>
</td>
<td>
</td>
</tr>
</table>
</td>
</tr>
<tr>
<td>
<code>status</code><br/>
<em>
<a href="#apisix.apache.org/v2.ApisixStatus">
ApisixStatus
</a>
</em>
</td>
<td>
</td>
</tr>
</tbody>
</table>
<h3 id="apisix.apache.org/v2.ApisixRouteAuthentication">ApisixRouteAuthentication
</h3>
<p>
(<em>Appears on:</em><a href="#apisix.apache.org/v2.ApisixRouteHTTP">ApisixRouteHTTP</a>)
</p>
<div>
<p>ApisixRouteAuthentication is the authentication-related
configuration in ApisixRoute.</p>
</div>
<table>
<thead>
<tr>
<th>Field</th>
<th>Description</th>
</tr>
</thead>
<tbody>
<tr>
<td>
<code>enable</code><br/>
<em>
bool
</em>
</td>
<td>
</td>
</tr>
<tr>
<td>
<code>type</code><br/>
<em>
string
</em>
</td>
<td>
</td>
</tr>
<tr>
<td>
<code>keyAuth</code><br/>
<em>
<a href="#apisix.apache.org/v2.ApisixRouteAuthenticationKeyAuth">
ApisixRouteAuthenticationKeyAuth
</a>
</em>
</td>
<td>
</td>
</tr>
<tr>
<td>
<code>jwtAuth</code><br/>
<em>
<a href="#apisix.apache.org/v2.ApisixRouteAuthenticationJwtAuth">
ApisixRouteAuthenticationJwtAuth
</a>
</em>
</td>
<td>
</td>
</tr>
</tbody>
</table>
<h3 id="apisix.apache.org/v2.ApisixRouteAuthenticationJwtAuth">ApisixRouteAuthenticationJwtAuth
</h3>
<p>
(<em>Appears on:</em><a href="#apisix.apache.org/v2.ApisixRouteAuthentication">ApisixRouteAuthentication</a>)
</p>
<div>
<p>ApisixRouteAuthenticationJwtAuth is the jwt auth related
configuration in ApisixRouteAuthentication.</p>
</div>
<table>
<thead>
<tr>
<th>Field</th>
<th>Description</th>
</tr>
</thead>
<tbody>
<tr>
<td>
<code>header</code><br/>
<em>
string
</em>
</td>
<td>
</td>
</tr>
<tr>
<td>
<code>query</code><br/>
<em>
string
</em>
</td>
<td>
</td>
</tr>
<tr>
<td>
<code>cookie</code><br/>
<em>
string
</em>
</td>
<td>
</td>
</tr>
</tbody>
</table>
<h3 id="apisix.apache.org/v2.ApisixRouteAuthenticationKeyAuth">ApisixRouteAuthenticationKeyAuth
</h3>
<p>
(<em>Appears on:</em><a href="#apisix.apache.org/v2.ApisixRouteAuthentication">ApisixRouteAuthentication</a>)
</p>
<div>
<p>ApisixRouteAuthenticationKeyAuth is the keyAuth-related
configuration in ApisixRouteAuthentication.</p>
</div>
<table>
<thead>
<tr>
<th>Field</th>
<th>Description</th>
</tr>
</thead>
<tbody>
<tr>
<td>
<code>header</code><br/>
<em>
string
</em>
</td>
<td>
</td>
</tr>
</tbody>
</table>
<h3 id="apisix.apache.org/v2.ApisixRouteHTTP">ApisixRouteHTTP
</h3>
<p>
(<em>Appears on:</em><a href="#apisix.apache.org/v2.ApisixRouteSpec">ApisixRouteSpec</a>)
</p>
<div>
<p>ApisixRouteHTTP represents a single route in for HTTP traffic.</p>
</div>
<table>
<thead>
<tr>
<th>Field</th>
<th>Description</th>
</tr>
</thead>
<tbody>
<tr>
<td>
<code>name</code><br/>
<em>
string
</em>
</td>
<td>
<p>The rule name, cannot be empty.</p>
</td>
</tr>
<tr>
<td>
<code>priority</code><br/>
<em>
int
</em>
</td>
<td>
<p>Route priority, when multiple routes contains
same URI path (for path matching), route with
higher priority will take effect.</p>
</td>
</tr>
<tr>
<td>
<code>timeout</code><br/>
<em>
<a href="#apisix.apache.org/v2.UpstreamTimeout">
UpstreamTimeout
</a>
</em>
</td>
<td>
</td>
</tr>
<tr>
<td>
<code>match</code><br/>
<em>
<a href="#apisix.apache.org/v2.ApisixRouteHTTPMatch">
ApisixRouteHTTPMatch
</a>
</em>
</td>
<td>
</td>
</tr>
<tr>
<td>
<code>backends</code><br/>
<em>
<a href="#apisix.apache.org/v2.ApisixRouteHTTPBackend">
[]ApisixRouteHTTPBackend
</a>
</em>
</td>
<td>
<p>Backends represents potential backends to proxy after the route
rule matched. When number of backends are more than one, traffic-split
plugin in APISIX will be used to split traffic based on the backend weight.</p>
</td>
</tr>
<tr>
<td>
<code>upstreams</code><br/>
<em>
<a href="#apisix.apache.org/v2.ApisixRouteUpstreamReference">
[]ApisixRouteUpstreamReference
</a>
</em>
</td>
<td>
<p>Upstreams refer to ApisixUpstream CRD</p>
</td>
</tr>
<tr>
<td>
<code>websocket</code><br/>
<em>
bool
</em>
</td>
<td>
</td>
</tr>
<tr>
<td>
<code>plugin_config_name</code><br/>
<em>
string
</em>
</td>
<td>
</td>
</tr>
<tr>
<td>
<code>plugins</code><br/>
<em>
<a href="#apisix.apache.org/v2.ApisixRoutePlugin">
[]ApisixRoutePlugin
</a>
</em>
</td>
<td>
</td>
</tr>
<tr>
<td>
<code>authentication</code><br/>
<em>
<a href="#apisix.apache.org/v2.ApisixRouteAuthentication">
ApisixRouteAuthentication
</a>
</em>
</td>
<td>
</td>
</tr>
</tbody>
</table>
<h3 id="apisix.apache.org/v2.ApisixRouteHTTPBackend">ApisixRouteHTTPBackend
</h3>
<p>
(<em>Appears on:</em><a href="#apisix.apache.org/v2.ApisixRouteHTTP">ApisixRouteHTTP</a>)
</p>
<div>
<p>ApisixRouteHTTPBackend represents an HTTP backend (a Kubernetes Service).</p>
</div>
<table>
<thead>
<tr>
<th>Field</th>
<th>Description</th>
</tr>
</thead>
<tbody>
<tr>
<td>
<code>serviceName</code><br/>
<em>
string
</em>
</td>
<td>
<p>The name (short) of the service, note cross namespace is forbidden,
so be sure the ApisixRoute and Service are in the same namespace.</p>
</td>
</tr>
<tr>
<td>
<code>servicePort</code><br/>
<em>
k8s.io/apimachinery/pkg/util/intstr.IntOrString
</em>
</td>
<td>
<p>The service port, could be the name or the port number.</p>
</td>
</tr>
<tr>
<td>
<code>resolveGranularity</code><br/>
<em>
string
</em>
</td>
<td>
<p>The resolve granularity, can be &ldquo;endpoints&rdquo; or &ldquo;service&rdquo;,
when set to &ldquo;endpoints&rdquo;, the pod ips will be used; other
wise, the service ClusterIP or ExternalIP will be used,
default is endpoints.</p>
</td>
</tr>
<tr>
<td>
<code>weight</code><br/>
<em>
int
</em>
</td>
<td>
<p>Weight of this backend.</p>
</td>
</tr>
<tr>
<td>
<code>subset</code><br/>
<em>
string
</em>
</td>
<td>
<p>Subset specifies a subset for the target Service. The subset should be pre-defined
in ApisixUpstream about this service.</p>
</td>
</tr>
</tbody>
</table>
<h3 id="apisix.apache.org/v2.ApisixRouteHTTPMatch">ApisixRouteHTTPMatch
</h3>
<p>
(<em>Appears on:</em><a href="#apisix.apache.org/v2.ApisixRouteHTTP">ApisixRouteHTTP</a>)
</p>
<div>
<p>ApisixRouteHTTPMatch represents the match condition for hitting this route.</p>
</div>
<table>
<thead>
<tr>
<th>Field</th>
<th>Description</th>
</tr>
</thead>
<tbody>
<tr>
<td>
<code>paths</code><br/>
<em>
[]string
</em>
</td>
<td>
<p>URI path predicates, at least one path should be
configured, path could be exact or prefix, for prefix path,
append &ldquo;<em>&rdquo; after it, for instance, &ldquo;/foo</em>&rdquo;.</p>
</td>
</tr>
<tr>
<td>
<code>methods</code><br/>
<em>
[]string
</em>
</td>
<td>
<p>HTTP request method predicates.</p>
</td>
</tr>
<tr>
<td>
<code>hosts</code><br/>
<em>
[]string
</em>
</td>
<td>
<p>HTTP Host predicates, host can be a wildcard domain or
an exact domain. For wildcard domain, only one generic
level is allowed, for instance, &ldquo;<em>.foo.com&rdquo; is valid but
&ldquo;</em>.*.foo.com&rdquo; is not.</p>
</td>
</tr>
<tr>
<td>
<code>remoteAddrs</code><br/>
<em>
[]string
</em>
</td>
<td>
<p>Remote address predicates, items can be valid IPv4 address
or IPv6 address or CIDR.</p>
</td>
</tr>
<tr>
<td>
<code>exprs</code><br/>
<em>
<a href="#apisix.apache.org/v2.ApisixRouteHTTPMatchExpr">
[]ApisixRouteHTTPMatchExpr
</a>
</em>
</td>
<td>
<p>NginxVars represents generic match predicates,
it uses Nginx variable systems, so any predicate
like headers, querystring and etc can be leveraged
here to match the route.
For instance, it can be:
nginxVars:
- subject: &ldquo;$remote_addr&rdquo;
op: in
value:
- &ldquo;127.0.0.1&rdquo;
- &ldquo;10.0.5.11&rdquo;</p>
</td>
</tr>
<tr>
<td>
<code>filter_func</code><br/>
<em>
string
</em>
</td>
<td>
<p>Matches based on a user-defined filtering function.
These functions can accept an input parameter <code>vars</code>
which can be used to access the Nginx variables.</p>
</td>
</tr>
</tbody>
</table>
<h3 id="apisix.apache.org/v2.ApisixRouteHTTPMatchExpr">ApisixRouteHTTPMatchExpr
</h3>
<p>
(<em>Appears on:</em><a href="#apisix.apache.org/v2.ApisixRouteHTTPMatch">ApisixRouteHTTPMatch</a>)
</p>
<div>
<p>ApisixRouteHTTPMatchExpr represents a binary route match expression .</p>
</div>
<table>
<thead>
<tr>
<th>Field</th>
<th>Description</th>
</tr>
</thead>
<tbody>
<tr>
<td>
<code>subject</code><br/>
<em>
<a href="#apisix.apache.org/v2.ApisixRouteHTTPMatchExprSubject">
ApisixRouteHTTPMatchExprSubject
</a>
</em>
</td>
<td>
<p>Subject is the expression subject, it can
be any string composed by literals and nginx
vars.</p>
</td>
</tr>
<tr>
<td>
<code>op</code><br/>
<em>
string
</em>
</td>
<td>
<p>Op is the operator.</p>
</td>
</tr>
<tr>
<td>
<code>set</code><br/>
<em>
[]string
</em>
</td>
<td>
<p>Set is an array type object of the expression.
It should be used when the Op is &ldquo;in&rdquo; or &ldquo;not_in&rdquo;;</p>
</td>
</tr>
<tr>
<td>
<code>value</code><br/>
<em>
string
</em>
</td>
<td>
<p>Value is the normal type object for the expression,
it should be used when the Op is not &ldquo;in&rdquo; and &ldquo;not_in&rdquo;.
Set and Value are exclusive so only of them can be set
in the same time.</p>
</td>
</tr>
</tbody>
</table>
<h3 id="apisix.apache.org/v2.ApisixRouteHTTPMatchExprSubject">ApisixRouteHTTPMatchExprSubject
</h3>
<p>
(<em>Appears on:</em><a href="#apisix.apache.org/v2.ApisixRouteHTTPMatchExpr">ApisixRouteHTTPMatchExpr</a>)
</p>
<div>
<p>ApisixRouteHTTPMatchExprSubject describes the route match expression subject.</p>
</div>
<table>
<thead>
<tr>
<th>Field</th>
<th>Description</th>
</tr>
</thead>
<tbody>
<tr>
<td>
<code>scope</code><br/>
<em>
string
</em>
</td>
<td>
<p>The subject scope, can be:
ScopeQuery, ScopeHeader, ScopePath
when subject is ScopePath, Name field
will be ignored.</p>
</td>
</tr>
<tr>
<td>
<code>name</code><br/>
<em>
string
</em>
</td>
<td>
<p>The name of subject.</p>
</td>
</tr>
</tbody>
</table>
<h3 id="apisix.apache.org/v2.ApisixRoutePlugin">ApisixRoutePlugin
</h3>
<p>
(<em>Appears on:</em><a href="#apisix.apache.org/v2.ApisixGlobalRuleSpec">ApisixGlobalRuleSpec</a>, <a href="#apisix.apache.org/v2.ApisixPluginConfigSpec">ApisixPluginConfigSpec</a>, <a href="#apisix.apache.org/v2.ApisixRouteHTTP">ApisixRouteHTTP</a>, <a href="#apisix.apache.org/v2.ApisixRouteStream">ApisixRouteStream</a>)
</p>
<div>
<p>ApisixRoutePlugin represents an APISIX plugin.</p>
</div>
<table>
<thead>
<tr>
<th>Field</th>
<th>Description</th>
</tr>
</thead>
<tbody>
<tr>
<td>
<code>name</code><br/>
<em>
string
</em>
</td>
<td>
<p>The plugin name.</p>
</td>
</tr>
<tr>
<td>
<code>enable</code><br/>
<em>
bool
</em>
</td>
<td>
<p>Whether this plugin is in use, default is true.</p>
</td>
</tr>
<tr>
<td>
<code>config</code><br/>
<em>
<a href="#apisix.apache.org/v2.ApisixRoutePluginConfig">
ApisixRoutePluginConfig
</a>
</em>
</td>
<td>
<p>Plugin configuration.</p>
</td>
</tr>
<tr>
<td>
<code>secretRef</code><br/>
<em>
string
</em>
</td>
<td>
<p>Plugin configuration secretRef.</p>
</td>
</tr>
</tbody>
</table>
<h3 id="apisix.apache.org/v2.ApisixRoutePluginConfig">ApisixRoutePluginConfig
(<code>map[string]interface{}</code> alias)</h3>
<p>
(<em>Appears on:</em><a href="#apisix.apache.org/v2.ApisixRoutePlugin">ApisixRoutePlugin</a>)
</p>
<div>
<p>ApisixRoutePluginConfig is the configuration for
any plugins.</p>
</div>
<h3 id="apisix.apache.org/v2.ApisixRouteSpec">ApisixRouteSpec
</h3>
<p>
(<em>Appears on:</em><a href="#apisix.apache.org/v2.ApisixRoute">ApisixRoute</a>)
</p>
<div>
<p>ApisixRouteSpec is the spec definition for ApisixRouteSpec.</p>
</div>
<table>
<thead>
<tr>
<th>Field</th>
<th>Description</th>
</tr>
</thead>
<tbody>
<tr>
<td>
<code>http</code><br/>
<em>
<a href="#apisix.apache.org/v2.ApisixRouteHTTP">
[]ApisixRouteHTTP
</a>
</em>
</td>
<td>
</td>
</tr>
<tr>
<td>
<code>stream</code><br/>
<em>
<a href="#apisix.apache.org/v2.ApisixRouteStream">
[]ApisixRouteStream
</a>
</em>
</td>
<td>
</td>
</tr>
</tbody>
</table>
<h3 id="apisix.apache.org/v2.ApisixRouteStream">ApisixRouteStream
</h3>
<p>
(<em>Appears on:</em><a href="#apisix.apache.org/v2.ApisixRouteSpec">ApisixRouteSpec</a>)
</p>
<div>
<p>ApisixRouteStream is the configuration for level 4 route</p>
</div>
<table>
<thead>
<tr>
<th>Field</th>
<th>Description</th>
</tr>
</thead>
<tbody>
<tr>
<td>
<code>name</code><br/>
<em>
string
</em>
</td>
<td>
<p>The rule name, cannot be empty.</p>
</td>
</tr>
<tr>
<td>
<code>protocol</code><br/>
<em>
string
</em>
</td>
<td>
</td>
</tr>
<tr>
<td>
<code>match</code><br/>
<em>
<a href="#apisix.apache.org/v2.ApisixRouteStreamMatch">
ApisixRouteStreamMatch
</a>
</em>
</td>
<td>
</td>
</tr>
<tr>
<td>
<code>backend</code><br/>
<em>
<a href="#apisix.apache.org/v2.ApisixRouteStreamBackend">
ApisixRouteStreamBackend
</a>
</em>
</td>
<td>
</td>
</tr>
<tr>
<td>
<code>plugins</code><br/>
<em>
<a href="#apisix.apache.org/v2.ApisixRoutePlugin">
[]ApisixRoutePlugin
</a>
</em>
</td>
<td>
</td>
</tr>
</tbody>
</table>
<h3 id="apisix.apache.org/v2.ApisixRouteStreamBackend">ApisixRouteStreamBackend
</h3>
<p>
(<em>Appears on:</em><a href="#apisix.apache.org/v2.ApisixRouteStream">ApisixRouteStream</a>)
</p>
<div>
<p>ApisixRouteStreamBackend represents a TCP backend (a Kubernetes Service).</p>
</div>
<table>
<thead>
<tr>
<th>Field</th>
<th>Description</th>
</tr>
</thead>
<tbody>
<tr>
<td>
<code>serviceName</code><br/>
<em>
string
</em>
</td>
<td>
<p>The name (short) of the service, note cross namespace is forbidden,
so be sure the ApisixRoute and Service are in the same namespace.</p>
</td>
</tr>
<tr>
<td>
<code>servicePort</code><br/>
<em>
k8s.io/apimachinery/pkg/util/intstr.IntOrString
</em>
</td>
<td>
<p>The service port, could be the name or the port number.</p>
</td>
</tr>
<tr>
<td>
<code>resolveGranularity</code><br/>
<em>
string
</em>
</td>
<td>
<p>The resolve granularity, can be &ldquo;endpoints&rdquo; or &ldquo;service&rdquo;,
when set to &ldquo;endpoints&rdquo;, the pod ips will be used; other
wise, the service ClusterIP or ExternalIP will be used,
default is endpoints.</p>
</td>
</tr>
<tr>
<td>
<code>subset</code><br/>
<em>
string
</em>
</td>
<td>
<p>Subset specifies a subset for the target Service. The subset should be pre-defined
in ApisixUpstream about this service.</p>
</td>
</tr>
</tbody>
</table>
<h3 id="apisix.apache.org/v2.ApisixRouteStreamMatch">ApisixRouteStreamMatch
</h3>
<p>
(<em>Appears on:</em><a href="#apisix.apache.org/v2.ApisixRouteStream">ApisixRouteStream</a>)
</p>
<div>
<p>ApisixRouteStreamMatch represents the match conditions of stream route.</p>
</div>
<table>
<thead>
<tr>
<th>Field</th>
<th>Description</th>
</tr>
</thead>
<tbody>
<tr>
<td>
<code>ingressPort</code><br/>
<em>
int32
</em>
</td>
<td>
<p>IngressPort represents the port listening on the Ingress proxy server.
It should be pre-defined as APISIX doesn&rsquo;t support dynamic listening.</p>
</td>
</tr>
<tr>
<td>
<code>host</code><br/>
<em>
string
</em>
</td>
<td>
</td>
</tr>
</tbody>
</table>
<h3 id="apisix.apache.org/v2.ApisixRouteUpstreamReference">ApisixRouteUpstreamReference
</h3>
<p>
(<em>Appears on:</em><a href="#apisix.apache.org/v2.ApisixRouteHTTP">ApisixRouteHTTP</a>)
</p>
<div>
<p>ApisixRouteUpstreamReference contains a ApisixUpstream CRD reference</p>
</div>
<table>
<thead>
<tr>
<th>Field</th>
<th>Description</th>
</tr>
</thead>
<tbody>
<tr>
<td>
<code>name</code><br/>
<em>
string
</em>
</td>
<td>
</td>
</tr>
<tr>
<td>
<code>weight</code><br/>
<em>
int
</em>
</td>
<td>
<em>(Optional)</em>
</td>
</tr>
</tbody>
</table>
<h3 id="apisix.apache.org/v2.ApisixSecret">ApisixSecret
</h3>
<p>
(<em>Appears on:</em><a href="#apisix.apache.org/v2.ApisixMutualTlsClientConfig">ApisixMutualTlsClientConfig</a>, <a href="#apisix.apache.org/v2.ApisixTlsSpec">ApisixTlsSpec</a>, <a href="#apisix.apache.org/v2.ApisixUpstreamConfig">ApisixUpstreamConfig</a>)
</p>
<div>
<p>ApisixSecret describes the Kubernetes Secret name and namespace.</p>
</div>
<table>
<thead>
<tr>
<th>Field</th>
<th>Description</th>
</tr>
</thead>
<tbody>
<tr>
<td>
<code>name</code><br/>
<em>
string
</em>
</td>
<td>
</td>
</tr>
<tr>
<td>
<code>namespace</code><br/>
<em>
string
</em>
</td>
<td>
</td>
</tr>
</tbody>
</table>
<h3 id="apisix.apache.org/v2.ApisixStatus">ApisixStatus
</h3>
<p>
(<em>Appears on:</em><a href="#apisix.apache.org/v2.ApisixGlobalRule">ApisixGlobalRule</a>, <a href="#apisix.apache.org/v2.ApisixPluginConfig">ApisixPluginConfig</a>, <a href="#apisix.apache.org/v2.ApisixClusterConfig">ApisixClusterConfig</a>, <a href="#apisix.apache.org/v2.ApisixConsumer">ApisixConsumer</a>, <a href="#apisix.apache.org/v2.ApisixRoute">ApisixRoute</a>, <a href="#apisix.apache.org/v2.ApisixTls">ApisixTls</a>, <a href="#apisix.apache.org/v2.ApisixUpstream">ApisixUpstream</a>)
</p>
<div>
<p>ApisixStatus is the status report for Apisix ingress Resources</p>
</div>
<table>
<thead>
<tr>
<th>Field</th>
<th>Description</th>
</tr>
</thead>
<tbody>
<tr>
<td>
<code>conditions</code><br/>
<em>
<a href="https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#condition-v1-meta">
[]Kubernetes meta/v1.Condition
</a>
</em>
</td>
<td>
</td>
</tr>
</tbody>
</table>
<h3 id="apisix.apache.org/v2.ApisixTls">ApisixTls
</h3>
<div>
<p>ApisixTls defines SSL resource in APISIX.</p>
</div>
<table>
<thead>
<tr>
<th>Field</th>
<th>Description</th>
</tr>
</thead>
<tbody>
<tr>
<td>
<code>metadata</code><br/>
<em>
<a href="https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#objectmeta-v1-meta">
Kubernetes meta/v1.ObjectMeta
</a>
</em>
</td>
<td>
Refer to the Kubernetes API documentation for the fields of the
<code>metadata</code> field.
</td>
</tr>
<tr>
<td>
<code>spec</code><br/>
<em>
<a href="#apisix.apache.org/v2.ApisixTlsSpec">
ApisixTlsSpec
</a>
</em>
</td>
<td>
<br/>
<br/>
<table>
</table>
</td>
</tr>
<tr>
<td>
<code>status</code><br/>
<em>
<a href="#apisix.apache.org/v2.ApisixStatus">
ApisixStatus
</a>
</em>
</td>
<td>
<em>(Optional)</em>
</td>
</tr>
</tbody>
</table>
<h3 id="apisix.apache.org/v2.ApisixTlsSpec">ApisixTlsSpec
</h3>
<p>
(<em>Appears on:</em><a href="#apisix.apache.org/v2.ApisixTls">ApisixTls</a>)
</p>
<div>
<p>ApisixTlsSpec is the specification of ApisixSSL.</p>
</div>
<table>
<thead>
<tr>
<th>Field</th>
<th>Description</th>
</tr>
</thead>
<tbody>
<tr>
<td>
<code>hosts</code><br/>
<em>
<a href="#apisix.apache.org/v2.HostType">
[]HostType
</a>
</em>
</td>
<td>
</td>
</tr>
<tr>
<td>
<code>secret</code><br/>
<em>
<a href="#apisix.apache.org/v2.ApisixSecret">
ApisixSecret
</a>
</em>
</td>
<td>
</td>
</tr>
<tr>
<td>
<code>client</code><br/>
<em>
<a href="#apisix.apache.org/v2.ApisixMutualTlsClientConfig">
ApisixMutualTlsClientConfig
</a>
</em>
</td>
<td>
<em>(Optional)</em>
</td>
</tr>
</tbody>
</table>
<h3 id="apisix.apache.org/v2.ApisixUpstream">ApisixUpstream
</h3>
<div>
<p>ApisixUpstream is a decorator for Kubernetes Service, it arms the Service
with rich features like health check, retry policies, load balancer and others.
It&rsquo;s designed to have same name with the Kubernetes Service and can be customized
for individual port.</p>
</div>
<table>
<thead>
<tr>
<th>Field</th>
<th>Description</th>
</tr>
</thead>
<tbody>
<tr>
<td>
<code>metadata</code><br/>
<em>
<a href="https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#objectmeta-v1-meta">
Kubernetes meta/v1.ObjectMeta
</a>
</em>
</td>
<td>
Refer to the Kubernetes API documentation for the fields of the
<code>metadata</code> field.
</td>
</tr>
<tr>
<td>
<code>spec</code><br/>
<em>
<a href="#apisix.apache.org/v2.ApisixUpstreamSpec">
ApisixUpstreamSpec
</a>
</em>
</td>
<td>
<br/>
<br/>
<table>
</table>
</td>
</tr>
<tr>
<td>
<code>status</code><br/>
<em>
<a href="#apisix.apache.org/v2.ApisixStatus">
ApisixStatus
</a>
</em>
</td>
<td>
</td>
</tr>
</tbody>
</table>
<h3 id="apisix.apache.org/v2.ApisixUpstreamConfig">ApisixUpstreamConfig
</h3>
<p>
(<em>Appears on:</em><a href="#apisix.apache.org/v2.ApisixUpstreamSpec">ApisixUpstreamSpec</a>, <a href="#apisix.apache.org/v2.PortLevelSettings">PortLevelSettings</a>)
</p>
<div>
<p>ApisixUpstreamConfig contains rich features on APISIX Upstream, for instance
load balancer, health check, etc.</p>
</div>
<table>
<thead>
<tr>
<th>Field</th>
<th>Description</th>
</tr>
</thead>
<tbody>
<tr>
<td>
<code>loadbalancer</code><br/>
<em>
<a href="#apisix.apache.org/v2.LoadBalancer">
LoadBalancer
</a>
</em>
</td>
<td>
<em>(Optional)</em>
<p>LoadBalancer represents the load balancer configuration for Kubernetes Service.
The default strategy is round robin.</p>
</td>
</tr>
<tr>
<td>
<code>scheme</code><br/>
<em>
string
</em>
</td>
<td>
<em>(Optional)</em>
<p>The scheme used to talk with the upstream.
Now value can be http, grpc.</p>
</td>
</tr>
<tr>
<td>
<code>retries</code><br/>
<em>
int
</em>
</td>
<td>
<em>(Optional)</em>
<p>How many times that the proxy (Apache APISIX) should do when
errors occur (error, timeout or bad http status codes like 500, 502).</p>
</td>
</tr>
<tr>
<td>
<code>timeout</code><br/>
<em>
<a href="#apisix.apache.org/v2.UpstreamTimeout">
UpstreamTimeout
</a>
</em>
</td>
<td>
<em>(Optional)</em>
<p>Timeout settings for the read, send and connect to the upstream.</p>
</td>
</tr>
<tr>
<td>
<code>healthCheck</code><br/>
<em>
<a href="#apisix.apache.org/v2.HealthCheck">
HealthCheck
</a>
</em>
</td>
<td>
<em>(Optional)</em>
<p>The health check configurations for the upstream.</p>
</td>
</tr>
<tr>
<td>
<code>tlsSecret</code><br/>
<em>
<a href="#apisix.apache.org/v2.ApisixSecret">
ApisixSecret
</a>
</em>
</td>
<td>
<em>(Optional)</em>
<p>Set the client certificate when connecting to TLS upstream.</p>
</td>
</tr>
<tr>
<td>
<code>subsets</code><br/>
<em>
<a href="#apisix.apache.org/v2.ApisixUpstreamSubset">
[]ApisixUpstreamSubset
</a>
</em>
</td>
<td>
<em>(Optional)</em>
<p>Subsets groups the service endpoints by their labels. Usually used to differentiate
service versions.</p>
</td>
</tr>
<tr>
<td>
<code>discovery</code><br/>
<em>
<a href="#apisix.apache.org/v2.Discovery">
Discovery
</a>
</em>
</td>
<td>
<em>(Optional)</em>
<p>Discovery is used to configure service discovery for upstream.</p>
</td>
</tr>
</tbody>
</table>
<h3 id="apisix.apache.org/v2.ApisixUpstreamExternalNode">ApisixUpstreamExternalNode
</h3>
<p>
(<em>Appears on:</em><a href="#apisix.apache.org/v2.ApisixUpstreamSpec">ApisixUpstreamSpec</a>)
</p>
<div>
<p>ApisixUpstreamExternalNode is the external node conf</p>
</div>
<table>
<thead>
<tr>
<th>Field</th>
<th>Description</th>
</tr>
</thead>
<tbody>
<tr>
<td>
<code>name</code><br/>
<em>
string
</em>
</td>
<td>
</td>
</tr>
<tr>
<td>
<code>type</code><br/>
<em>
<a href="#apisix.apache.org/v2.ApisixUpstreamExternalType">
ApisixUpstreamExternalType
</a>
</em>
</td>
<td>
</td>
</tr>
<tr>
<td>
<code>weight</code><br/>
<em>
int
</em>
</td>
<td>
<em>(Optional)</em>
</td>
</tr>
<tr>
<td>
<code>port</code><br/>
<em>
int
</em>
</td>
<td>
<em>(Optional)</em>
<p>Port defines the port of the external node</p>
</td>
</tr>
</tbody>
</table>
<h3 id="apisix.apache.org/v2.ApisixUpstreamExternalType">ApisixUpstreamExternalType
(<code>string</code> alias)</h3>
<p>
(<em>Appears on:</em><a href="#apisix.apache.org/v2.ApisixUpstreamExternalNode">ApisixUpstreamExternalNode</a>)
</p>
<div>
<p>ApisixUpstreamExternalType is the external service type</p>
</div>
<table>
<thead>
<tr>
<th>Value</th>
<th>Description</th>
</tr>
</thead>
<tbody><tr><td><p>&#34;Domain&#34;</p></td>
<td><p>ExternalTypeDomain type is a domain</p>
</td>
</tr><tr><td><p>&#34;Service&#34;</p></td>
<td><p>ExternalTypeService type is a K8s ExternalName service</p>
</td>
</tr></tbody>
</table>
<h3 id="apisix.apache.org/v2.ApisixUpstreamSpec">ApisixUpstreamSpec
</h3>
<p>
(<em>Appears on:</em><a href="#apisix.apache.org/v2.ApisixUpstream">ApisixUpstream</a>)
</p>
<div>
<p>ApisixUpstreamSpec describes the specification of ApisixUpstream.</p>
</div>
<table>
<thead>
<tr>
<th>Field</th>
<th>Description</th>
</tr>
</thead>
<tbody>
<tr>
<td>
<code>externalNodes</code><br/>
<em>
<a href="#apisix.apache.org/v2.ApisixUpstreamExternalNode">
[]ApisixUpstreamExternalNode
</a>
</em>
</td>
<td>
<em>(Optional)</em>
<p>ExternalNodes contains external nodes the Upstream should use
If this field is set, the upstream will use these nodes directly without any further resolves</p>
</td>
</tr>
<tr>
<td>
<code>ApisixUpstreamConfig</code><br/>
<em>
<a href="#apisix.apache.org/v2.ApisixUpstreamConfig">
ApisixUpstreamConfig
</a>
</em>
</td>
<td>
<p>
(Members of <code>ApisixUpstreamConfig</code> are embedded into this type.)
</p>
</td>
</tr>
<tr>
<td>
<code>portLevelSettings</code><br/>
<em>
<a href="#apisix.apache.org/v2.PortLevelSettings">
[]PortLevelSettings
</a>
</em>
</td>
<td>
</td>
</tr>
</tbody>
</table>
<h3 id="apisix.apache.org/v2.ApisixUpstreamSubset">ApisixUpstreamSubset
</h3>
<p>
(<em>Appears on:</em><a href="#apisix.apache.org/v2.ApisixUpstreamConfig">ApisixUpstreamConfig</a>)
</p>
<div>
<p>ApisixUpstreamSubset defines a single endpoints group of one Service.</p>
</div>
<table>
<thead>
<tr>
<th>Field</th>
<th>Description</th>
</tr>
</thead>
<tbody>
<tr>
<td>
<code>name</code><br/>
<em>
string
</em>
</td>
<td>
<p>Name is the name of subset.</p>
</td>
</tr>
<tr>
<td>
<code>labels</code><br/>
<em>
map[string]string
</em>
</td>
<td>
<p>Labels is the label set of this subset.</p>
</td>
</tr>
</tbody>
</table>
<h3 id="apisix.apache.org/v2.Config">Config
(<code>map[string]interface{}</code> alias)</h3>
<p>
(<em>Appears on:</em><a href="#apisix.apache.org/v2.Plugin">Plugin</a>)
</p>
<div>
</div>
<h3 id="apisix.apache.org/v2.ConfigSet">ConfigSet
(<code>[]interface{}</code> alias)</h3>
<p>
(<em>Appears on:</em><a href="#apisix.apache.org/v2.Plugin">Plugin</a>)
</p>
<div>
</div>
<h3 id="apisix.apache.org/v2.Discovery">Discovery
</h3>
<p>
(<em>Appears on:</em><a href="#apisix.apache.org/v2.ApisixUpstreamConfig">ApisixUpstreamConfig</a>)
</p>
<div>
<p>Discovery defines Service discovery related configuration.</p>
</div>
<table>
<thead>
<tr>
<th>Field</th>
<th>Description</th>
</tr>
</thead>
<tbody>
<tr>
<td>
<code>serviceName</code><br/>
<em>
string
</em>
</td>
<td>
</td>
</tr>
<tr>
<td>
<code>type</code><br/>
<em>
string
</em>
</td>
<td>
</td>
</tr>
<tr>
<td>
<code>args</code><br/>
<em>
map[string]string
</em>
</td>
<td>
</td>
</tr>
</tbody>
</table>
<h3 id="apisix.apache.org/v2.HealthCheck">HealthCheck
</h3>
<p>
(<em>Appears on:</em><a href="#apisix.apache.org/v2.ApisixUpstreamConfig">ApisixUpstreamConfig</a>)
</p>
<div>
<p>HealthCheck describes the upstream health check parameters.</p>
</div>
<table>
<thead>
<tr>
<th>Field</th>
<th>Description</th>
</tr>
</thead>
<tbody>
<tr>
<td>
<code>active</code><br/>
<em>
<a href="#apisix.apache.org/v2.ActiveHealthCheck">
ActiveHealthCheck
</a>
</em>
</td>
<td>
</td>
</tr>
<tr>
<td>
<code>passive</code><br/>
<em>
<a href="#apisix.apache.org/v2.PassiveHealthCheck">
PassiveHealthCheck
</a>
</em>
</td>
<td>
</td>
</tr>
</tbody>
</table>
<h3 id="apisix.apache.org/v2.HostType">HostType
(<code>string</code> alias)</h3>
<p>
(<em>Appears on:</em><a href="#apisix.apache.org/v2.ApisixTlsSpec">ApisixTlsSpec</a>)
</p>
<div>
</div>
<h3 id="apisix.apache.org/v2.LoadBalancer">LoadBalancer
</h3>
<p>
(<em>Appears on:</em><a href="#apisix.apache.org/v2.ApisixUpstreamConfig">ApisixUpstreamConfig</a>)
</p>
<div>
<p>LoadBalancer describes the load balancing parameters.</p>
</div>
<table>
<thead>
<tr>
<th>Field</th>
<th>Description</th>
</tr>
</thead>
<tbody>
<tr>
<td>
<code>type</code><br/>
<em>
string
</em>
</td>
<td>
</td>
</tr>
<tr>
<td>
<code>hashOn</code><br/>
<em>
string
</em>
</td>
<td>
<p>The HashOn and Key fields are required when Type is &ldquo;chash&rdquo;.
HashOn represents the key fetching scope.</p>
</td>
</tr>
<tr>
<td>
<code>key</code><br/>
<em>
string
</em>
</td>
<td>
<p>Key represents the hash key.</p>
</td>
</tr>
</tbody>
</table>
<h3 id="apisix.apache.org/v2.PassiveHealthCheck">PassiveHealthCheck
</h3>
<p>
(<em>Appears on:</em><a href="#apisix.apache.org/v2.HealthCheck">HealthCheck</a>)
</p>
<div>
<p>PassiveHealthCheck defines the conditions to judge whether
an upstream node is healthy with the passive manager.</p>
</div>
<table>
<thead>
<tr>
<th>Field</th>
<th>Description</th>
</tr>
</thead>
<tbody>
<tr>
<td>
<code>type</code><br/>
<em>
string
</em>
</td>
<td>
</td>
</tr>
<tr>
<td>
<code>healthy</code><br/>
<em>
<a href="#apisix.apache.org/v2.PassiveHealthCheckHealthy">
PassiveHealthCheckHealthy
</a>
</em>
</td>
<td>
</td>
</tr>
<tr>
<td>
<code>unhealthy</code><br/>
<em>
<a href="#apisix.apache.org/v2.PassiveHealthCheckUnhealthy">
PassiveHealthCheckUnhealthy
</a>
</em>
</td>
<td>
</td>
</tr>
</tbody>
</table>
<h3 id="apisix.apache.org/v2.PassiveHealthCheckHealthy">PassiveHealthCheckHealthy
</h3>
<p>
(<em>Appears on:</em><a href="#apisix.apache.org/v2.ActiveHealthCheckHealthy">ActiveHealthCheckHealthy</a>, <a href="#apisix.apache.org/v2.PassiveHealthCheck">PassiveHealthCheck</a>)
</p>
<div>
<p>PassiveHealthCheckHealthy defines the conditions to judge whether
an upstream node is healthy with the passive manner.</p>
</div>
<table>
<thead>
<tr>
<th>Field</th>
<th>Description</th>
</tr>
</thead>
<tbody>
<tr>
<td>
<code>httpCodes</code><br/>
<em>
[]int
</em>
</td>
<td>
</td>
</tr>
<tr>
<td>
<code>successes</code><br/>
<em>
int
</em>
</td>
<td>
</td>
</tr>
</tbody>
</table>
<h3 id="apisix.apache.org/v2.PassiveHealthCheckUnhealthy">PassiveHealthCheckUnhealthy
</h3>
<p>
(<em>Appears on:</em><a href="#apisix.apache.org/v2.ActiveHealthCheckUnhealthy">ActiveHealthCheckUnhealthy</a>, <a href="#apisix.apache.org/v2.PassiveHealthCheck">PassiveHealthCheck</a>)
</p>
<div>
<p>PassiveHealthCheckUnhealthy defines the conditions to judge whether
an upstream node is unhealthy with the passive manager.</p>
</div>
<table>
<thead>
<tr>
<th>Field</th>
<th>Description</th>
</tr>
</thead>
<tbody>
<tr>
<td>
<code>httpCodes</code><br/>
<em>
[]int
</em>
</td>
<td>
</td>
</tr>
<tr>
<td>
<code>httpFailures</code><br/>
<em>
int
</em>
</td>
<td>
</td>
</tr>
<tr>
<td>
<code>tcpFailures</code><br/>
<em>
int
</em>
</td>
<td>
</td>
</tr>
<tr>
<td>
<code>timeout</code><br/>
<em>
int
</em>
</td>
<td>
</td>
</tr>
</tbody>
</table>
<h3 id="apisix.apache.org/v2.Plugin">Plugin
</h3>
<div>
</div>
<table>
<thead>
<tr>
<th>Field</th>
<th>Description</th>
</tr>
</thead>
<tbody>
<tr>
<td>
<code>name</code><br/>
<em>
string
</em>
</td>
<td>
</td>
</tr>
<tr>
<td>
<code>enable</code><br/>
<em>
bool
</em>
</td>
<td>
</td>
</tr>
<tr>
<td>
<code>config</code><br/>
<em>
<a href="#apisix.apache.org/v2.Config">
Config
</a>
</em>
</td>
<td>
</td>
</tr>
<tr>
<td>
<code>config_set</code><br/>
<em>
<a href="#apisix.apache.org/v2.ConfigSet">
ConfigSet
</a>
</em>
</td>
<td>
</td>
</tr>
</tbody>
</table>
<h3 id="apisix.apache.org/v2.PortLevelSettings">PortLevelSettings
</h3>
<p>
(<em>Appears on:</em><a href="#apisix.apache.org/v2.ApisixUpstreamSpec">ApisixUpstreamSpec</a>)
</p>
<div>
<p>PortLevelSettings configures the ApisixUpstreamConfig for each individual port. It inherits
configurations from the outer level (the whole Kubernetes Service) and overrides some of
them if they are set on the port level.</p>
</div>
<table>
<thead>
<tr>
<th>Field</th>
<th>Description</th>
</tr>
</thead>
<tbody>
<tr>
<td>
<code>ApisixUpstreamConfig</code><br/>
<em>
<a href="#apisix.apache.org/v2.ApisixUpstreamConfig">
ApisixUpstreamConfig
</a>
</em>
</td>
<td>
<p>
(Members of <code>ApisixUpstreamConfig</code> are embedded into this type.)
</p>
</td>
</tr>
<tr>
<td>
<code>port</code><br/>
<em>
int32
</em>
</td>
<td>
<p>Port is a Kubernetes Service port, it should be already defined.</p>
</td>
</tr>
</tbody>
</table>
<h3 id="apisix.apache.org/v2.UpstreamTimeout">UpstreamTimeout
</h3>
<p>
(<em>Appears on:</em><a href="#apisix.apache.org/v2.ApisixRouteHTTP">ApisixRouteHTTP</a>, <a href="#apisix.apache.org/v2.ApisixUpstreamConfig">ApisixUpstreamConfig</a>)
</p>
<div>
<p>UpstreamTimeout is settings for the read, send and connect to the upstream.</p>
</div>
<table>
<thead>
<tr>
<th>Field</th>
<th>Description</th>
</tr>
</thead>
<tbody>
<tr>
<td>
<code>connect</code><br/>
<em>
<a href="https://godoc.org/k8s.io/apimachinery/pkg/apis/meta/v1#Duration">
Kubernetes meta/v1.Duration
</a>
</em>
</td>
<td>
</td>
</tr>
<tr>
<td>
<code>send</code><br/>
<em>
<a href="https://godoc.org/k8s.io/apimachinery/pkg/apis/meta/v1#Duration">
Kubernetes meta/v1.Duration
</a>
</em>
</td>
<td>
</td>
</tr>
<tr>
<td>
<code>read</code><br/>
<em>
<a href="https://godoc.org/k8s.io/apimachinery/pkg/apis/meta/v1#Duration">
Kubernetes meta/v1.Duration
</a>
</em>
</td>
<td>
</td>
</tr>
</tbody>
</table>
<hr/>
<p><em>
Generated with <code>gen-crd-api-reference-docs</code>
on git commit <code>fa57ff5</code>.
</em></p>
