/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.vault.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.vault.config.ClientAuthenticationFactory;
import org.springframework.cloud.vault.config.ConditionalOnAuthentication;
import org.springframework.cloud.vault.config.DefaultRestTemplateFactory;
import org.springframework.cloud.vault.config.VaultConfiguration;
import org.springframework.cloud.vault.config.VaultProperties;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.annotation.Order;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.vault.authentication.ClientAuthentication;
import org.springframework.vault.authentication.SessionManager;
import org.springframework.vault.client.RestTemplateBuilder;
import org.springframework.vault.client.RestTemplateCustomizer;
import org.springframework.vault.client.RestTemplateFactory;
import org.springframework.vault.client.RestTemplateRequestCustomizer;
import org.springframework.vault.client.SimpleVaultEndpointProvider;
import org.springframework.vault.client.VaultEndpoint;
import org.springframework.vault.client.VaultEndpointProvider;
import org.springframework.vault.config.AbstractVaultConfiguration;
import org.springframework.vault.core.VaultOperations;
import org.springframework.vault.core.VaultTemplate;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(name={"spring.cloud.vault.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={VaultProperties.class})
@Order(value=0x7FFFFFFA)
public class VaultAutoConfiguration {
    private final ConfigurableApplicationContext applicationContext;
    private final VaultProperties vaultProperties;
    private final VaultConfiguration configuration;
    private final VaultEndpointProvider endpointProvider;
    private final List<RestTemplateCustomizer> customizers;
    private final List<RestTemplateRequestCustomizer<?>> requestCustomizers;

    public VaultAutoConfiguration(ConfigurableApplicationContext applicationContext, VaultProperties vaultProperties, ObjectProvider<VaultEndpointProvider> endpointProvider, ObjectProvider<List<RestTemplateCustomizer>> customizers, ObjectProvider<List<RestTemplateRequestCustomizer<?>>> requestCustomizers) {
        this.applicationContext = applicationContext;
        this.vaultProperties = vaultProperties;
        this.configuration = new VaultConfiguration(vaultProperties);
        VaultEndpointProvider provider = (VaultEndpointProvider)endpointProvider.getIfAvailable();
        if (provider == null) {
            provider = SimpleVaultEndpointProvider.of((VaultEndpoint)this.configuration.createVaultEndpoint());
        }
        this.endpointProvider = provider;
        this.customizers = new ArrayList<RestTemplateCustomizer>((Collection)customizers.getIfAvailable(Collections::emptyList));
        AnnotationAwareOrderComparator.sort(this.customizers);
        this.requestCustomizers = new ArrayList((Collection)requestCustomizers.getIfAvailable(Collections::emptyList));
        AnnotationAwareOrderComparator.sort(this.requestCustomizers);
    }

    protected RestTemplateBuilder restTemplateBuilder(ClientHttpRequestFactory requestFactory) {
        return this.configuration.createRestTemplateBuilder(requestFactory, this.endpointProvider, this.customizers, this.requestCustomizers);
    }

    @Bean
    @ConditionalOnMissingBean
    public AbstractVaultConfiguration.ClientFactoryWrapper clientHttpRequestFactoryWrapper() {
        return new AbstractVaultConfiguration.ClientFactoryWrapper(this.configuration.createClientHttpRequestFactory());
    }

    @Bean
    @ConditionalOnMissingBean
    public RestTemplateFactory vaultRestTemplateFactory(AbstractVaultConfiguration.ClientFactoryWrapper clientFactoryWrapper) {
        return new DefaultRestTemplateFactory(clientFactoryWrapper.getClientHttpRequestFactory(), this::restTemplateBuilder);
    }

    @Bean
    @ConditionalOnMissingBean(value={VaultOperations.class})
    public VaultTemplate vaultTemplate(AbstractVaultConfiguration.ClientFactoryWrapper clientFactoryWrapper) {
        VaultProperties.AuthenticationMethod authentication = this.vaultProperties.getAuthentication();
        RestTemplateBuilder restTemplateBuilder = this.restTemplateBuilder(clientFactoryWrapper.getClientHttpRequestFactory());
        if (authentication == VaultProperties.AuthenticationMethod.NONE) {
            return new VaultTemplate(restTemplateBuilder);
        }
        return new VaultTemplate(restTemplateBuilder, (SessionManager)this.applicationContext.getBean(SessionManager.class));
    }

    @Bean
    @Lazy
    @ConditionalOnMissingBean(value={TaskSchedulerWrapper.class})
    public TaskSchedulerWrapper vaultTaskScheduler() {
        ThreadPoolTaskScheduler threadPoolTaskScheduler = VaultConfiguration.createScheduler();
        this.applicationContext.registerShutdownHook();
        return new TaskSchedulerWrapper(threadPoolTaskScheduler);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnAuthentication
    public SessionManager vaultSessionManager(ClientAuthentication clientAuthentication, ObjectFactory<TaskSchedulerWrapper> asyncTaskExecutorFactory, RestTemplateFactory restTemplateFactory) {
        return this.configuration.createSessionManager(clientAuthentication, () -> ((TaskSchedulerWrapper)asyncTaskExecutorFactory.getObject()).getTaskScheduler(), restTemplateFactory);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnAuthentication
    public ClientAuthentication clientAuthentication(AbstractVaultConfiguration.ClientFactoryWrapper clientFactoryWrapper, RestTemplateFactory restTemplateFactory) {
        RestTemplate externalRestOperations = new RestTemplate(clientFactoryWrapper.getClientHttpRequestFactory());
        this.customizers.forEach(customizer -> customizer.customize(externalRestOperations));
        RestTemplate restTemplate = restTemplateFactory.create();
        ClientAuthenticationFactory factory = new ClientAuthenticationFactory(this.vaultProperties, (RestOperations)restTemplate, (RestOperations)externalRestOperations);
        return factory.createClientAuthentication();
    }

    public static class TaskSchedulerWrapper
    implements InitializingBean,
    DisposableBean {
        private final ThreadPoolTaskScheduler taskScheduler;
        private final boolean acceptAfterPropertiesSet;

        public TaskSchedulerWrapper(ThreadPoolTaskScheduler taskScheduler) {
            this(taskScheduler, true);
        }

        public TaskSchedulerWrapper(ThreadPoolTaskScheduler taskScheduler, boolean acceptAfterPropertiesSet) {
            this.taskScheduler = taskScheduler;
            this.acceptAfterPropertiesSet = acceptAfterPropertiesSet;
        }

        public ThreadPoolTaskScheduler getTaskScheduler() {
            return this.taskScheduler;
        }

        public void destroy() {
            this.taskScheduler.destroy();
        }

        public void afterPropertiesSet() {
            if (this.acceptAfterPropertiesSet) {
                this.taskScheduler.afterPropertiesSet();
            }
        }
    }
}

