/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect.bridge;

import javax.management.ObjectName;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.management.ManagementService;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeFromPolicyManager;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeManager;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeManagerControlType;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgePolicyManager;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgePolicyManagerControlType;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeReceiver;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeReceiverControlType;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeReceiverInfo;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeSenderControlType;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeToPolicyManager;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeToSenderController;
import org.apache.activemq.artemis.utils.CompositeAddress;

public final class AMQPBridgeManagementSupport {
    public static final String BRIDGE_MANAGER_RESOURCE_TEMPLATE = "brokerconnection.%s.bridge.%s";
    public static final String BRIDGE_POLICY_RESOURCE_TEMPLATE = "brokerconnection.%s.bridge.%s.policy.%s";
    public static final String BRIDGE_RECEIVER_RESOURCE_TEMPLATE = "brokerconnection.%s.bridge.%s.policy.%s.receiver.%s";
    public static final String BRIDGE_SENDER_RESOURCE_TEMPLATE = "brokerconnection.%s.bridge.%s.policy.%s.sender.%s";
    public static final String BRIDGE_NAME_TEMPLATE = "serviceCatagory=bridge,bridgeName=%s";
    public static final String BRIDGE_POLICY_NAME_TEMPLATE = "serviceCatagory=bridge,bridgeName=%s,policyType=%s,policyName=%s";
    public static final String BRIDGE_QUEUE_RECEIVER_NAME_TEMPLATE = "serviceCatagory=bridge,bridgeName=%s,policyType=%s,policyName=%s,linkType=receivers,fqqn=%s";
    public static final String BRIDGE_ADDRESS_RECEIVER_NAME_TEMPLATE = "serviceCatagory=bridge,bridgeName=%s,policyType=%s,policyName=%s,linkType=receivers,address=%s";
    public static final String BRIDGE_QUEUE_SENDER_NAME_TEMPLATE = "serviceCatagory=bridge,bridgeName=%s,policyType=%s,policyName=%s,linkType=senders,fqqn=%s";
    public static final String BRIDGE_ADDRESS_SENDER_NAME_TEMPLATE = "serviceCatagory=bridge,bridgeName=%s,policyType=%s,policyName=%s,linkType=senders,address=%s";

    public static void registerBridgeManager(AMQPBridgeManager bridge) throws Exception {
        String bridgeName = bridge.getName();
        String brokerConnectionName = bridge.getBrokerConnection().getName();
        ActiveMQServer server = bridge.getServer();
        ManagementService management = server.getManagementService();
        AMQPBridgeManagerControlType control = new AMQPBridgeManagerControlType(server, bridge);
        management.registerInJMX(AMQPBridgeManagementSupport.getBridgeManagerObjectName(management, brokerConnectionName, bridgeName), (Object)control);
        management.registerInRegistry(AMQPBridgeManagementSupport.getBridgeManagerResourceName(brokerConnectionName, bridgeName), (Object)control);
    }

    public static void unregisterBridgeManager(AMQPBridgeManager bridge) throws Exception {
        String bridgeName = bridge.getName();
        String brokerConnectionName = bridge.getBrokerConnection().getName();
        ActiveMQServer server = bridge.getServer();
        ManagementService management = server.getManagementService();
        management.unregisterFromJMX(AMQPBridgeManagementSupport.getBridgeManagerObjectName(management, brokerConnectionName, bridgeName));
        management.unregisterFromRegistry(AMQPBridgeManagementSupport.getBridgeManagerResourceName(brokerConnectionName, bridgeName));
    }

    public static String getBridgeManagerResourceName(String brokerConnectionName, String bridgeName) {
        return String.format(BRIDGE_MANAGER_RESOURCE_TEMPLATE, brokerConnectionName, bridgeName);
    }

    public static ObjectName getBridgeManagerObjectName(ManagementService management, String brokerConnection, String bridgeName) throws Exception {
        return ObjectName.getInstance(String.format("%s,serviceCatagory=bridge,bridgeName=%s", management.getObjectNameBuilder().getBrokerConnectionBaseObjectNameString(brokerConnection), ObjectName.quote(bridgeName)));
    }

    public static void registerBridgePolicyManager(AMQPBridgePolicyManager manager) throws Exception {
        AMQPBridgeManager bridgeManager = manager.getBridgeManager();
        String brokerConnectionName = bridgeManager.getBrokerConnection().getName();
        ActiveMQServer server = bridgeManager.getServer();
        ManagementService management = server.getManagementService();
        AMQPBridgePolicyManagerControlType control = new AMQPBridgePolicyManagerControlType(manager);
        String bridgeName = bridgeManager.getName();
        String policyName = manager.getPolicyName();
        management.registerInJMX(AMQPBridgeManagementSupport.getBridgePolicyManagerObjectName(management, brokerConnectionName, bridgeName, manager.getPolicyType().toString(), policyName), (Object)control);
        management.registerInRegistry(AMQPBridgeManagementSupport.getBridgePolicyManagerResourceName(brokerConnectionName, bridgeName, policyName), (Object)control);
    }

    public static void unregisterBridgePolicyManager(AMQPBridgePolicyManager manager) throws Exception {
        AMQPBridgeManager bridgeManager = manager.getBridgeManager();
        String brokerConnectionName = bridgeManager.getBrokerConnection().getName();
        ActiveMQServer server = bridgeManager.getServer();
        ManagementService management = server.getManagementService();
        String bridgeName = bridgeManager.getName();
        String policyName = manager.getPolicyName();
        management.unregisterFromJMX(AMQPBridgeManagementSupport.getBridgePolicyManagerObjectName(management, brokerConnectionName, bridgeName, manager.getPolicyType().toString(), policyName));
        management.unregisterFromRegistry(AMQPBridgeManagementSupport.getBridgePolicyManagerResourceName(brokerConnectionName, bridgeName, policyName));
    }

    public static String getBridgePolicyManagerResourceName(String brokerConnectionName, String bridgeName, String policyName) {
        return String.format(BRIDGE_POLICY_RESOURCE_TEMPLATE, brokerConnectionName, bridgeName, policyName);
    }

    public static ObjectName getBridgePolicyManagerObjectName(ManagementService management, String brokerConnection, String bridgeName, String policyType, String policyName) throws Exception {
        return ObjectName.getInstance(String.format("%s,serviceCatagory=bridge,bridgeName=%s,policyType=%s,policyName=%s", management.getObjectNameBuilder().getBrokerConnectionBaseObjectNameString(brokerConnection), ObjectName.quote(bridgeName), ObjectName.quote(policyType), ObjectName.quote(policyName)));
    }

    public static void registerBridgeReceiver(AMQPBridgeReceiver receiver) throws Exception {
        AMQPBridgeFromPolicyManager manager = receiver.getPolicyManager();
        AMQPBridgeManager bridgeManager = manager.getBridgeManager();
        String brokerConnectionName = bridgeManager.getBrokerConnection().getName();
        ActiveMQServer server = bridgeManager.getServer();
        ManagementService management = server.getManagementService();
        AMQPBridgeReceiverControlType control = new AMQPBridgeReceiverControlType(receiver);
        String bridgeName = bridgeManager.getName();
        String policyName = manager.getPolicyName();
        if (receiver.getRole() == AMQPBridgeReceiverInfo.ReceiverRole.ADDRESS_RECEIVER) {
            management.registerInJMX(AMQPBridgeManagementSupport.getBridgeAddressReceiverObjectName(management, brokerConnectionName, bridgeName, manager.getPolicyType().toString(), policyName, receiver.getReceiverInfo().getLocalAddress()), (Object)control);
            management.registerInRegistry(AMQPBridgeManagementSupport.getBridgeAddressReceiverResourceName(brokerConnectionName, bridgeName, policyName, receiver.getReceiverInfo().getLocalAddress()), (Object)control);
        } else {
            management.registerInJMX(AMQPBridgeManagementSupport.getBridgeQueueReceiverObjectName(management, brokerConnectionName, bridgeName, manager.getPolicyType().toString(), policyName, receiver.getReceiverInfo().getLocalFqqn()), (Object)control);
            management.registerInRegistry(AMQPBridgeManagementSupport.getBridgeQueueReceiverResourceName(brokerConnectionName, bridgeName, policyName, receiver.getReceiverInfo().getLocalFqqn()), (Object)control);
        }
    }

    public static void unregisterBridgeReceiver(AMQPBridgeReceiver receiver) throws Exception {
        AMQPBridgeFromPolicyManager manager = receiver.getPolicyManager();
        AMQPBridgeManager bridgeManager = manager.getBridgeManager();
        String brokerConnectionName = bridgeManager.getBrokerConnection().getName();
        ActiveMQServer server = bridgeManager.getServer();
        ManagementService management = server.getManagementService();
        String bridgeName = bridgeManager.getName();
        String policyName = manager.getPolicyName();
        if (receiver.getRole() == AMQPBridgeReceiverInfo.ReceiverRole.ADDRESS_RECEIVER) {
            management.unregisterFromJMX(AMQPBridgeManagementSupport.getBridgeAddressReceiverObjectName(management, brokerConnectionName, bridgeName, manager.getPolicyType().toString(), policyName, receiver.getReceiverInfo().getLocalAddress()));
            management.unregisterFromRegistry(AMQPBridgeManagementSupport.getBridgeAddressReceiverResourceName(brokerConnectionName, bridgeName, policyName, receiver.getReceiverInfo().getLocalAddress()));
        } else {
            management.unregisterFromJMX(AMQPBridgeManagementSupport.getBridgeQueueReceiverObjectName(management, brokerConnectionName, bridgeName, manager.getPolicyType().toString(), policyName, receiver.getReceiverInfo().getLocalFqqn()));
            management.unregisterFromRegistry(AMQPBridgeManagementSupport.getBridgeQueueReceiverResourceName(brokerConnectionName, bridgeName, policyName, receiver.getReceiverInfo().getLocalFqqn()));
        }
    }

    public static String getBridgeAddressReceiverResourceName(String brokerConnectionName, String bridgeName, String policyName, String address) {
        return String.format(BRIDGE_RECEIVER_RESOURCE_TEMPLATE, brokerConnectionName, bridgeName, policyName, address);
    }

    public static ObjectName getBridgeAddressReceiverObjectName(ManagementService management, String brokerConnection, String bridgeName, String policyType, String policyName, String address) throws Exception {
        return ObjectName.getInstance(String.format("%s,serviceCatagory=bridge,bridgeName=%s,policyType=%s,policyName=%s,linkType=receivers,address=%s", management.getObjectNameBuilder().getBrokerConnectionBaseObjectNameString(brokerConnection), ObjectName.quote(bridgeName), ObjectName.quote(policyType), ObjectName.quote(policyName), ObjectName.quote(address)));
    }

    public static String getBridgeQueueReceiverResourceName(String brokerConnectionName, String bridgeName, String policyName, String fqqn) {
        return String.format(BRIDGE_RECEIVER_RESOURCE_TEMPLATE, brokerConnectionName, bridgeName, policyName, fqqn);
    }

    public static ObjectName getBridgeQueueReceiverObjectName(ManagementService management, String brokerConnection, String bridgeName, String policyType, String policyName, String fqqn) throws Exception {
        return ObjectName.getInstance(String.format("%s,serviceCatagory=bridge,bridgeName=%s,policyType=%s,policyName=%s,linkType=receivers,fqqn=%s", management.getObjectNameBuilder().getBrokerConnectionBaseObjectNameString(brokerConnection), ObjectName.quote(bridgeName), ObjectName.quote(policyType), ObjectName.quote(policyName), ObjectName.quote(fqqn)));
    }

    public static void registerBridgeSender(AMQPBridgeToSenderController sender) throws Exception {
        AMQPBridgeToPolicyManager manager = sender.getPolicyManager();
        AMQPBridgeManager bridgeManager = manager.getBridgeManager();
        String brokerConnectionName = bridgeManager.getBrokerConnection().getName();
        ActiveMQServer server = bridgeManager.getServer();
        ManagementService management = server.getManagementService();
        AMQPBridgeSenderControlType control = new AMQPBridgeSenderControlType(sender);
        String bridgeName = bridgeManager.getName();
        String policyName = manager.getPolicyName();
        if (sender.getRole() == AMQPBridgeToSenderController.SenderRole.ADDRESS_SENDER) {
            String address = control.getAddress();
            management.registerInJMX(AMQPBridgeManagementSupport.getBridgeAddressSenderObjectName(management, brokerConnectionName, bridgeName, manager.getPolicyType().toString(), policyName, address), (Object)control);
            management.registerInRegistry(AMQPBridgeManagementSupport.getBridgeAddressSenderResourceName(brokerConnectionName, bridgeName, policyName, address), (Object)control);
        } else {
            String fqqn = control.getFqqn();
            management.registerInJMX(AMQPBridgeManagementSupport.getBridgeQueueSenderObjectName(management, brokerConnectionName, bridgeName, manager.getPolicyType().toString(), policyName, fqqn), (Object)control);
            management.registerInRegistry(AMQPBridgeManagementSupport.getBridgeQueueSenderResourceName(brokerConnectionName, bridgeName, policyName, fqqn), (Object)control);
        }
    }

    public static void unregisterBridgeSender(AMQPBridgeToSenderController sender) throws Exception {
        AMQPBridgeToPolicyManager manager = sender.getPolicyManager();
        AMQPBridgeManager bridgeManager = manager.getBridgeManager();
        String brokerConnectionName = bridgeManager.getBrokerConnection().getName();
        ActiveMQServer server = bridgeManager.getServer();
        ManagementService management = server.getManagementService();
        String bridgeName = bridgeManager.getName();
        String policyName = manager.getPolicyName();
        if (sender.getRole() == AMQPBridgeToSenderController.SenderRole.ADDRESS_SENDER) {
            String address = sender.getServerConsumer().getQueueAddress().toString();
            management.unregisterFromJMX(AMQPBridgeManagementSupport.getBridgeAddressSenderObjectName(management, brokerConnectionName, bridgeName, manager.getPolicyType().toString(), policyName, address));
            management.unregisterFromRegistry(AMQPBridgeManagementSupport.getBridgeAddressSenderResourceName(brokerConnectionName, bridgeName, policyName, address));
        } else {
            String fqqn = CompositeAddress.toFullyQualified((String)sender.getServerConsumer().getQueueAddress().toString(), (String)sender.getServerConsumer().getQueueName().toString());
            management.unregisterFromJMX(AMQPBridgeManagementSupport.getBridgeQueueSenderObjectName(management, brokerConnectionName, bridgeName, manager.getPolicyType().toString(), policyName, fqqn));
            management.unregisterFromRegistry(AMQPBridgeManagementSupport.getBridgeQueueSenderResourceName(brokerConnectionName, bridgeName, policyName, fqqn));
        }
    }

    public static String getBridgeAddressSenderResourceName(String brokerConnectionName, String bridgeName, String policyName, String address) {
        return String.format(BRIDGE_SENDER_RESOURCE_TEMPLATE, brokerConnectionName, bridgeName, policyName, address);
    }

    public static ObjectName getBridgeAddressSenderObjectName(ManagementService management, String brokerConnection, String bridgeName, String policyType, String policyName, String address) throws Exception {
        return ObjectName.getInstance(String.format("%s,serviceCatagory=bridge,bridgeName=%s,policyType=%s,policyName=%s,linkType=senders,address=%s", management.getObjectNameBuilder().getBrokerConnectionBaseObjectNameString(brokerConnection), ObjectName.quote(bridgeName), ObjectName.quote(policyType), ObjectName.quote(policyName), ObjectName.quote(address)));
    }

    public static String getBridgeQueueSenderResourceName(String brokerConnectionName, String bridgeName, String policyName, String fqqn) {
        return String.format(BRIDGE_SENDER_RESOURCE_TEMPLATE, brokerConnectionName, bridgeName, policyName, fqqn);
    }

    public static ObjectName getBridgeQueueSenderObjectName(ManagementService management, String brokerConnection, String bridgeName, String policyType, String policyName, String fqqn) throws Exception {
        return ObjectName.getInstance(String.format("%s,serviceCatagory=bridge,bridgeName=%s,policyType=%s,policyName=%s,linkType=senders,fqqn=%s", management.getObjectNameBuilder().getBrokerConnectionBaseObjectNameString(brokerConnection), ObjectName.quote(bridgeName), ObjectName.quote(policyType), ObjectName.quote(policyName), ObjectName.quote(fqqn)));
    }

    private AMQPBridgeManagementSupport() {
    }
}

