/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect.federation;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPConnectionContext;

public final class AMQPFederationConfiguration {
    public static final int DEFAULT_LINK_ATTACH_TIMEOUT = 30;
    public static final int DEFAULT_PULL_CREDIT_BATCH_SIZE = 100;
    public static final boolean DEFAULT_CORE_MESSAGE_TUNNELING_ENABLED = true;
    public static final boolean DEFAULT_IGNORE_ADDRESS_BINDING_FILTERS = true;
    public static final boolean DEFAULT_IGNORE_QUEUE_CONSUMER_FILTERS = false;
    public static final boolean DEFAULT_IGNORE_QUEUE_CONSUMER_PRIORITIES = true;
    public static final int DEFAULT_RECEIVER_QUIESCE_TIMEOUT = 60000;
    public static final int DEFAULT_ADDRESS_RECEIVER_IDLE_TIMEOUT = 5000;
    public static final int DEFAULT_QUEUE_RECEIVER_IDLE_TIMEOUT = 60000;
    public static final boolean DEFAULT_USE_MODIFIED_FOR_TRANSIENT_DELIVERY_ERRORS = true;
    private final Map<String, Object> properties;
    private final AMQPConnectionContext connection;

    public AMQPFederationConfiguration(AMQPConnectionContext connection, Map<String, Object> properties) {
        Objects.requireNonNull(connection, "Connection provided cannot be null");
        this.connection = connection;
        this.properties = properties != null && !properties.isEmpty() ? new HashMap<String, Object>(properties) : Collections.emptyMap();
    }

    public int getReceiverCredits() {
        Object property = this.properties.get("amqpCredits");
        if (property instanceof Number) {
            Number number = (Number)property;
            return number.intValue();
        }
        if (property instanceof String) {
            String string = (String)property;
            return Integer.parseInt(string);
        }
        return this.connection.getAmqpCredits();
    }

    public int getReceiverCreditsLow() {
        Object property = this.properties.get("amqpLowCredits");
        if (property instanceof Number) {
            Number number = (Number)property;
            return number.intValue();
        }
        if (property instanceof String) {
            String string = (String)property;
            return Integer.parseInt(string);
        }
        return this.connection.getAmqpLowCredits();
    }

    public int getPullReceiverBatchSize() {
        Object property = this.properties.get("amqpPullConsumerCredits");
        if (property instanceof Number) {
            Number number = (Number)property;
            return number.intValue();
        }
        if (property instanceof String) {
            String string = (String)property;
            return Integer.parseInt(string);
        }
        return 100;
    }

    public int getLargeMessageThreshold() {
        Object property = this.properties.get("minLargeMessageSize");
        if (property instanceof Number) {
            Number number = (Number)property;
            return number.intValue();
        }
        if (property instanceof String) {
            String string = (String)property;
            return Integer.parseInt(string);
        }
        return this.connection.getProtocolManager().getAmqpMinLargeMessageSize();
    }

    public int getLinkAttachTimeout() {
        Object property = this.properties.get("attach-timeout");
        if (property instanceof Number) {
            Number number = (Number)property;
            return number.intValue();
        }
        if (property instanceof String) {
            String string = (String)property;
            return Integer.parseInt(string);
        }
        return 30;
    }

    public boolean isCoreMessageTunnelingEnabled() {
        Object property = this.properties.get("tunnel-core-messages");
        if (property instanceof Boolean) {
            Boolean booleanValue = (Boolean)property;
            return booleanValue;
        }
        if (property instanceof String) {
            String string = (String)property;
            return Boolean.parseBoolean(string);
        }
        return true;
    }

    public boolean isIgnoreAddressBindingFilters() {
        Object property = this.properties.get("ignoreAddressBindingFilters");
        if (property instanceof Boolean) {
            Boolean booleanValue = (Boolean)property;
            return booleanValue;
        }
        if (property instanceof String) {
            String string = (String)property;
            return Boolean.parseBoolean(string);
        }
        return true;
    }

    public boolean isIgnoreSubscriptionFilters() {
        Object property = this.properties.get("ignoreQueueConsumerFilters");
        if (property instanceof Boolean) {
            Boolean booleanValue = (Boolean)property;
            return booleanValue;
        }
        if (property instanceof String) {
            String string = (String)property;
            return Boolean.parseBoolean(string);
        }
        return false;
    }

    public boolean isIgnoreSubscriptionPriorities() {
        Object property = this.properties.get("ignoreQueueConsumerPriorities");
        if (property instanceof Boolean) {
            Boolean booleanValue = (Boolean)property;
            return booleanValue;
        }
        if (property instanceof String) {
            String string = (String)property;
            return Boolean.parseBoolean(string);
        }
        return true;
    }

    public int getReceiverQuiesceTimeout() {
        Object property = this.properties.get("receiverQuiesceTimeout");
        if (property instanceof Number) {
            Number number = (Number)property;
            return number.intValue();
        }
        if (property instanceof String) {
            String string = (String)property;
            return Integer.parseInt(string);
        }
        return 60000;
    }

    public int getAddressReceiverIdleTimeout() {
        Object property = this.properties.get("addressReceiverIdleTimeout");
        if (property instanceof Number) {
            Number number = (Number)property;
            return number.intValue();
        }
        if (property instanceof String) {
            String string = (String)property;
            return Integer.parseInt(string);
        }
        return 5000;
    }

    public int getQueueReceiverIdleTimeout() {
        Object property = this.properties.get("queueReceiverIdleTimeout");
        if (property instanceof Number) {
            Number number = (Number)property;
            return number.intValue();
        }
        if (property instanceof String) {
            String string = (String)property;
            return Integer.parseInt(string);
        }
        return 60000;
    }

    public boolean isUseModifiedForTransientDeliveryErrors() {
        Object property = this.properties.get("amqpUseModifiedForTransientDeliveryErrors");
        if (property instanceof Boolean) {
            Boolean booleanValue = (Boolean)property;
            return booleanValue;
        }
        if (property instanceof String) {
            String string = (String)property;
            return Boolean.parseBoolean(string);
        }
        return true;
    }

    public boolean isDrainOnTransientDeliveryErrors() {
        Object property = this.properties.get("amqpDrainOnTransientDeliveryErrors");
        if (property instanceof Boolean) {
            Boolean booleanValue = (Boolean)property;
            return booleanValue;
        }
        if (property instanceof String) {
            String string = (String)property;
            return Boolean.parseBoolean(string);
        }
        return this.connection.getProtocolManager().isDrainOnTransientDeliveryErrors();
    }

    public int getLinkQuiesceTimeout() {
        Object property = this.properties.get("amqpLinkQuiesceTimeout");
        if (property instanceof Number) {
            Number number = (Number)property;
            return number.intValue();
        }
        if (property instanceof String) {
            String string = (String)property;
            return Integer.parseInt(string);
        }
        return this.connection.getProtocolManager().getLinkQuiesceTimeout();
    }

    public Map<String, Object> toConfigurationMap() {
        HashMap<String, Object> configMap = new HashMap<String, Object>();
        configMap.put("amqpCredits", this.getReceiverCredits());
        configMap.put("amqpLowCredits", this.getReceiverCreditsLow());
        configMap.put("receiverQuiesceTimeout", this.getReceiverQuiesceTimeout());
        configMap.put("addressReceiverIdleTimeout", this.getAddressReceiverIdleTimeout());
        configMap.put("queueReceiverIdleTimeout", this.getQueueReceiverIdleTimeout());
        configMap.put("amqpPullConsumerCredits", this.getPullReceiverBatchSize());
        configMap.put("minLargeMessageSize", this.getLargeMessageThreshold());
        configMap.put("attach-timeout", this.getLinkAttachTimeout());
        configMap.put("ignoreAddressBindingFilters", this.isIgnoreAddressBindingFilters());
        configMap.put("ignoreQueueConsumerFilters", this.isIgnoreSubscriptionFilters());
        configMap.put("ignoreQueueConsumerPriorities", this.isIgnoreSubscriptionPriorities());
        configMap.put("amqpUseModifiedForTransientDeliveryErrors", this.isUseModifiedForTransientDeliveryErrors());
        configMap.put("amqpLinkQuiesceTimeout", this.getLinkQuiesceTimeout());
        configMap.put("amqpDrainOnTransientDeliveryErrors", this.isDrainOnTransientDeliveryErrors());
        configMap.put("tunnel-core-messages", this.isCoreMessageTunnelingEnabled());
        return configMap;
    }
}

