/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.metrics;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.binder.cache.CaffeineCacheMetrics;
import io.micrometer.core.instrument.binder.jvm.ExecutorServiceMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmGcMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmMemoryMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmThreadMetrics;
import io.micrometer.core.instrument.binder.logging.Log4j2Metrics;
import io.micrometer.core.instrument.binder.netty4.NettyMeters;
import io.micrometer.core.instrument.binder.system.FileDescriptorMetrics;
import io.micrometer.core.instrument.binder.system.ProcessorMetrics;
import io.micrometer.core.instrument.binder.system.UptimeMetrics;
import io.micrometer.core.instrument.config.MeterFilter;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.SingleThreadEventExecutor;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import java.util.function.ToDoubleFunction;
import org.apache.activemq.artemis.core.config.MetricsConfiguration;
import org.apache.activemq.artemis.core.security.SecurityStore;
import org.apache.activemq.artemis.core.security.impl.SecurityStoreImpl;
import org.apache.activemq.artemis.core.server.ActiveMQMessageBundle;
import org.apache.activemq.artemis.core.server.metrics.NettyPooledAllocatorMetrics;
import org.apache.activemq.artemis.core.settings.HierarchicalRepository;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsManager {
    public static final String BROKER_TAG_NAME = "broker";
    public static final String METER_PREFIX = "artemis.";
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final String brokerName;
    private final Tags commonTags;
    private final MeterRegistry meterRegistry;
    private final Map<String, Collection<Meter>> meters = new ConcurrentHashMap<String, Collection<Meter>>();
    private final HierarchicalRepository<AddressSettings> addressSettingsRepository;
    private final MetricsConfiguration metricsConfiguration;

    public MetricsManager(String brokerName, MetricsConfiguration metricsConfiguration, HierarchicalRepository<AddressSettings> addressSettingsRepository, SecurityStore securityStore) {
        this.brokerName = brokerName;
        this.metricsConfiguration = metricsConfiguration;
        this.meterRegistry = metricsConfiguration.getPlugin().getRegistry();
        this.addressSettingsRepository = addressSettingsRepository;
        this.commonTags = Tags.of((String)BROKER_TAG_NAME, (String)brokerName);
        if (this.meterRegistry != null) {
            this.meterRegistry.config().meterFilter(new MeterFilter(){

                public Meter.Id map(Meter.Id id) {
                    if (id.getName().equals(NettyMeters.EVENT_EXECUTOR_TASKS_PENDING.getName())) {
                        return id.withTags((Iterable)MetricsManager.this.commonTags);
                    }
                    return id;
                }
            });
            Metrics.globalRegistry.add(this.meterRegistry);
            if (metricsConfiguration.isJvmMemory()) {
                new JvmMemoryMetrics((Iterable)this.commonTags).bindTo(this.meterRegistry);
            }
            if (metricsConfiguration.isJvmGc()) {
                new JvmGcMetrics((Iterable)this.commonTags).bindTo(this.meterRegistry);
            }
            if (metricsConfiguration.isJvmThread()) {
                new JvmThreadMetrics((Iterable)this.commonTags).bindTo(this.meterRegistry);
            }
            if (metricsConfiguration.isNettyPool()) {
                new NettyPooledAllocatorMetrics(PooledByteBufAllocator.DEFAULT.metric(), this.commonTags).bindTo(this.meterRegistry);
            }
            if (metricsConfiguration.isFileDescriptors()) {
                new FileDescriptorMetrics((Iterable)this.commonTags).bindTo(this.meterRegistry);
            }
            if (metricsConfiguration.isProcessor()) {
                new ProcessorMetrics((Iterable)this.commonTags).bindTo(this.meterRegistry);
            }
            if (metricsConfiguration.isUptime()) {
                new UptimeMetrics((Iterable)this.commonTags).bindTo(this.meterRegistry);
            }
            if (metricsConfiguration.isLogging()) {
                new Log4j2Metrics((Iterable)this.commonTags).bindTo(this.meterRegistry);
            }
            if (metricsConfiguration.isSecurityCaches() && securityStore.isSecurityEnabled()) {
                CaffeineCacheMetrics.monitor((MeterRegistry)this.meterRegistry, ((SecurityStoreImpl)securityStore).getAuthenticationCache(), (String)"authentication", (Iterable)this.commonTags);
                CaffeineCacheMetrics.monitor((MeterRegistry)this.meterRegistry, ((SecurityStoreImpl)securityStore).getAuthorizationCache(), (String)"authorization", (Iterable)this.commonTags);
            }
        }
    }

    public MeterRegistry getMeterRegistry() {
        return this.meterRegistry;
    }

    public void registerQueueGauge(String address, String queue, Consumer<MetricGaugeBuilder> builder) {
        if (this.meterRegistry == null || !this.addressSettingsRepository.getMatch(address).isEnableMetrics()) {
            return;
        }
        ArrayList<Gauge.Builder<Object>> gaugeBuilders = new ArrayList<Gauge.Builder<Object>>();
        builder.accept((metricName, state, f, description, gaugeTags) -> {
            Gauge.Builder meter = Gauge.builder((String)(METER_PREFIX + metricName), (Object)state, (ToDoubleFunction)f).tags((Iterable)this.commonTags).tags((Iterable)gaugeTags).tag("address", address).tag("queue", queue).description(description);
            gaugeBuilders.add(meter);
        });
        this.registerMeters(gaugeBuilders, "queue." + queue);
    }

    public void registerAddressGauge(String address, Consumer<MetricGaugeBuilder> builder) {
        if (this.meterRegistry == null || !this.addressSettingsRepository.getMatch(address).isEnableMetrics()) {
            return;
        }
        ArrayList<Gauge.Builder<Object>> gaugeBuilders = new ArrayList<Gauge.Builder<Object>>();
        builder.accept((metricName, state, f, description, gaugeTags) -> {
            Gauge.Builder meter = Gauge.builder((String)(METER_PREFIX + metricName), (Object)state, (ToDoubleFunction)f).tags((Iterable)this.commonTags).tags((Iterable)gaugeTags).tag("address", address).description(description);
            gaugeBuilders.add(meter);
        });
        this.registerMeters(gaugeBuilders, "address." + address);
    }

    public void registerBrokerGauge(Consumer<MetricGaugeBuilder> builder) {
        if (this.meterRegistry == null) {
            return;
        }
        ArrayList<Gauge.Builder<Object>> gaugeBuilders = new ArrayList<Gauge.Builder<Object>>();
        builder.accept((metricName, state, f, description, gaugeTags) -> {
            Gauge.Builder meter = Gauge.builder((String)(METER_PREFIX + metricName), (Object)state, (ToDoubleFunction)f).tags((Iterable)this.commonTags).tags((Iterable)gaugeTags).description(description);
            gaugeBuilders.add(meter);
        });
        this.registerMeters(gaugeBuilders, "broker." + this.brokerName);
    }

    private void registerMeters(List<Gauge.Builder<Object>> gaugeBuilders, String resource) {
        if (this.meters.get(resource) != null) {
            throw ActiveMQMessageBundle.BUNDLE.metersAlreadyRegistered(resource);
        }
        logger.debug("Registering meters for {}", (Object)resource);
        HashSet<Gauge> newMeters = new HashSet<Gauge>(gaugeBuilders.size());
        for (Gauge.Builder<Object> gaugeBuilder : gaugeBuilders) {
            Gauge gauge = gaugeBuilder.register(this.meterRegistry);
            newMeters.add(gauge);
            logger.debug("Registered meter: {}", (Object)gauge.getId());
        }
        this.meters.put(resource, newMeters);
    }

    public void remove(String resource) {
        Collection<Meter> resourceMeters = this.meters.remove(resource);
        if (resourceMeters != null) {
            logger.debug("Unregistering meters for {}", (Object)resource);
            for (Meter meter : resourceMeters) {
                Meter removed = this.meterRegistry.remove(meter);
                if (removed != null) {
                    logger.debug("Unregistered meter: {}", (Object)removed.getId());
                    continue;
                }
                logger.debug("Attempted to unregister meter {}, but it wasn't found in the registry", (Object)meter);
            }
        } else {
            logger.debug("Attempted to unregister meters for {}, but none were found.", (Object)resource);
        }
    }

    public void registerExecutorService(String name, ExecutorService executorService) {
        if (this.meterRegistry == null || !this.metricsConfiguration.isExecutorServices()) {
            return;
        }
        logger.debug("Registering ExecutorService for {}: {}", (Object)name, (Object)executorService);
        ExecutorServiceMetrics.monitor((MeterRegistry)this.meterRegistry, (ExecutorService)executorService, (String)name, (Iterable)this.commonTags);
    }

    public void registerNettyEventLoopGroup(String name, EventLoopGroup eventLoopGroup) {
        if (this.meterRegistry == null || !this.metricsConfiguration.isExecutorServices()) {
            return;
        }
        String resource = "acceptor." + name;
        if (this.meters.get(resource) != null) {
            throw ActiveMQMessageBundle.BUNDLE.metersAlreadyRegistered(resource);
        }
        logger.debug("Registering Netty EventLoopGroup for {}: {}", (Object)name, (Object)eventLoopGroup);
        HashSet meters = new HashSet();
        eventLoopGroup.forEach(eventExecutor -> {
            if (eventExecutor instanceof SingleThreadEventExecutor) {
                SingleThreadEventExecutor singleThreadEventExecutor = (SingleThreadEventExecutor)eventExecutor;
                Gauge meter = Gauge.builder((String)NettyMeters.EVENT_EXECUTOR_TASKS_PENDING.getName(), () -> ((SingleThreadEventExecutor)singleThreadEventExecutor).pendingTasks()).tag("name", singleThreadEventExecutor.threadProperties().name()).tags((Iterable)this.commonTags).register(this.meterRegistry);
                meters.add(meter);
                logger.debug("Registered meter: {}", (Object)meter.getId());
            }
        });
        if (!meters.isEmpty()) {
            this.meters.put(resource, meters);
        }
    }

    @FunctionalInterface
    public static interface MetricGaugeBuilder {
        public void build(String var1, Object var2, ToDoubleFunction<Object> var3, String var4, List<Tag> var5);
    }
}

