/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.security;

import org.apache.activemq.artemis.core.security.Role;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum CheckType {
    SEND{

        @Override
        public boolean hasRole(Role role) {
            return role.isSend();
        }
    }
    ,
    CONSUME{

        @Override
        public boolean hasRole(Role role) {
            return role.isConsume();
        }
    }
    ,
    CREATE_ADDRESS{

        @Override
        public boolean hasRole(Role role) {
            return role.isCreateAddress();
        }
    }
    ,
    DELETE_ADDRESS{

        @Override
        public boolean hasRole(Role role) {
            return role.isDeleteAddress();
        }
    }
    ,
    CREATE_DURABLE_QUEUE{

        @Override
        public boolean hasRole(Role role) {
            return role.isCreateDurableQueue();
        }
    }
    ,
    DELETE_DURABLE_QUEUE{

        @Override
        public boolean hasRole(Role role) {
            return role.isDeleteDurableQueue();
        }
    }
    ,
    CREATE_NON_DURABLE_QUEUE{

        @Override
        public boolean hasRole(Role role) {
            return role.isCreateNonDurableQueue();
        }
    }
    ,
    DELETE_NON_DURABLE_QUEUE{

        @Override
        public boolean hasRole(Role role) {
            return role.isDeleteNonDurableQueue();
        }
    }
    ,
    MANAGE{

        @Override
        public boolean hasRole(Role role) {
            return role.isManage();
        }
    }
    ,
    BROWSE{

        @Override
        public boolean hasRole(Role role) {
            return role.isBrowse();
        }
    }
    ,
    VIEW{

        @Override
        public boolean hasRole(Role role) {
            return role.isView();
        }
    }
    ,
    EDIT{

        @Override
        public boolean hasRole(Role role) {
            return role.isEdit();
        }
    };


    public static Object[] asObjectArray(Role role) {
        return new Object[]{role.getName(), SEND.hasRole(role), CONSUME.hasRole(role), CREATE_DURABLE_QUEUE.hasRole(role), DELETE_DURABLE_QUEUE.hasRole(role), CREATE_NON_DURABLE_QUEUE.hasRole(role), DELETE_NON_DURABLE_QUEUE.hasRole(role), MANAGE.hasRole(role), BROWSE.hasRole(role), CREATE_ADDRESS.hasRole(role), DELETE_ADDRESS.hasRole(role), VIEW.hasRole(role), EDIT.hasRole(role)};
    }

    public abstract boolean hasRole(Role var1);
}

